/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.util;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.lock.ResourceLock;
import org.apache.seata.rm.BaseDataSourceResource;
import org.apache.seata.rm.DefaultResourceManager;
import org.apache.seata.sqlparser.util.DbTypeParser;

public final class JdbcUtils {
    private static volatile DbTypeParser dbTypeParser;
    private static final ResourceLock RESOURCE_LOCK;

    static DbTypeParser getDbTypeParser() {
        if (dbTypeParser == null) {
            try (ResourceLock ignored = RESOURCE_LOCK.obtain();){
                if (dbTypeParser == null) {
                    dbTypeParser = EnhancedServiceLoader.load(DbTypeParser.class, "druid");
                }
            }
        }
        return dbTypeParser;
    }

    private JdbcUtils() {
    }

    public static String getDbType(String jdbcUrl) {
        return JdbcUtils.getDbTypeParser().parseFromJdbcUrl(jdbcUrl).toLowerCase();
    }

    public static void initDataSourceResource(BaseDataSourceResource dataSourceResource, DataSource dataSource, String resourceGroupId) {
        dataSourceResource.setResourceGroupId(resourceGroupId);
        try (Connection connection = dataSource.getConnection();){
            String jdbcUrl = connection.getMetaData().getURL();
            dataSourceResource.setResourceId(JdbcUtils.buildResourceId(jdbcUrl));
            String driverClassName = com.alibaba.druid.util.JdbcUtils.getDriverClassName((String)jdbcUrl);
            dataSourceResource.setDriver(JdbcUtils.loadDriver(driverClassName));
            dataSourceResource.setDbType(JdbcUtils.getDbType(jdbcUrl));
        }
        catch (SQLException e) {
            throw new IllegalStateException("can not init DataSourceResource with " + dataSource, e);
        }
        DefaultResourceManager.get().registerResource(dataSourceResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initXADataSourceResource(BaseDataSourceResource dataSourceResource, XADataSource dataSource, String resourceGroupId) {
        dataSourceResource.setResourceGroupId(resourceGroupId);
        try (XAConnection xaConnection = dataSource.getXAConnection();
             Connection connection = xaConnection.getConnection();){
            String jdbcUrl = connection.getMetaData().getURL();
            dataSourceResource.setResourceId(JdbcUtils.buildResourceId(jdbcUrl));
            String driverClassName = com.alibaba.druid.util.JdbcUtils.getDriverClassName((String)jdbcUrl);
            dataSourceResource.setDriver(JdbcUtils.loadDriver(driverClassName));
            dataSourceResource.setDbType(JdbcUtils.getDbType(jdbcUrl));
        }
        catch (SQLException e) {
            throw new IllegalStateException("can not get XAConnection from DataSourceResource with " + dataSource, e);
        }
        DefaultResourceManager.get().registerResource(dataSourceResource);
    }

    public static String buildResourceId(String jdbcUrl) {
        if (jdbcUrl.contains("?")) {
            return jdbcUrl.substring(0, jdbcUrl.indexOf(63));
        }
        return jdbcUrl;
    }

    public static Driver loadDriver(String driverClassName) throws SQLException {
        Class<?> clazz = null;
        try {
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            if (contextLoader != null) {
                clazz = contextLoader.loadClass(driverClassName);
            }
        }
        catch (ClassNotFoundException contextLoader) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(driverClassName);
            }
            catch (ClassNotFoundException e) {
                throw new SQLException(e.getMessage(), e);
            }
        }
        try {
            return (Driver)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    static {
        RESOURCE_LOCK = new ResourceLock();
    }
}

