/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.tcc.interceptor.parser;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.seata.common.exception.FrameworkException;
import org.apache.seata.common.util.ReflectionUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.model.Resource;
import org.apache.seata.integration.tx.api.interceptor.ActionContextUtil;
import org.apache.seata.integration.tx.api.interceptor.handler.ProxyInvocationHandler;
import org.apache.seata.integration.tx.api.interceptor.parser.DefaultTargetClassParser;
import org.apache.seata.integration.tx.api.interceptor.parser.IfNeedEnhanceBean;
import org.apache.seata.integration.tx.api.interceptor.parser.InterfaceParser;
import org.apache.seata.integration.tx.api.interceptor.parser.NeedEnhanceEnum;
import org.apache.seata.integration.tx.api.remoting.parser.DefaultRemotingParser;
import org.apache.seata.rm.DefaultResourceManager;
import org.apache.seata.rm.tcc.TCCResource;
import org.apache.seata.rm.tcc.api.TwoPhaseBusinessAction;
import org.apache.seata.rm.tcc.interceptor.TccActionInterceptorHandler;

public class TccActionInterceptorParser
implements InterfaceParser {
    @Override
    public ProxyInvocationHandler parserInterfaceToProxy(Object target, String objectName) throws Exception {
        Class<?> targetClass = DefaultTargetClassParser.get().findTargetClass(target);
        Map<Method, Class<?>> methodClassMap = ReflectionUtil.findMatchMethodClazzMap(targetClass, method -> method.isAnnotationPresent(this.getAnnotationClass()));
        Set<Method> methodsToProxy = methodClassMap.keySet();
        if (methodsToProxy.isEmpty()) {
            return null;
        }
        this.registerResource(target, methodClassMap);
        return new TccActionInterceptorHandler(target, methodsToProxy.stream().map(Method::getName).collect(Collectors.toSet()));
    }

    @Override
    public IfNeedEnhanceBean parseIfNeedEnhancement(Class<?> beanClass) {
        IfNeedEnhanceBean ifNeedEnhanceBean = new IfNeedEnhanceBean();
        if (DefaultRemotingParser.get().isService(beanClass)) {
            ifNeedEnhanceBean.setIfNeed(true);
            ifNeedEnhanceBean.setNeedEnhanceEnum(NeedEnhanceEnum.SERVICE_BEAN);
        }
        return ifNeedEnhanceBean;
    }

    protected void registerResource(Object target, Map<Method, Class<?>> methodClassMap) {
        try {
            for (Map.Entry<Method, Class<?>> methodClassEntry : methodClassMap.entrySet()) {
                Method method = methodClassEntry.getKey();
                Annotation annotation = method.getAnnotation(this.getAnnotationClass());
                if (annotation == null) continue;
                Resource resource = this.createResource(target, methodClassEntry.getValue(), method, annotation);
                DefaultResourceManager.get().registerResource(resource);
            }
        }
        catch (Throwable t) {
            throw new FrameworkException(t, "register tcc resource error");
        }
    }

    protected Class<? extends Annotation> getAnnotationClass() {
        return TwoPhaseBusinessAction.class;
    }

    protected Resource createResource(Object target, Class<?> targetServiceClass, Method m, Annotation annotation) throws NoSuchMethodException {
        TwoPhaseBusinessAction twoPhaseBusinessAction = (TwoPhaseBusinessAction)annotation;
        TCCResource tccResource = new TCCResource();
        if (StringUtils.isBlank(twoPhaseBusinessAction.name())) {
            throw new FrameworkException("TCC bean name cannot be null or empty");
        }
        tccResource.setActionName(twoPhaseBusinessAction.name());
        tccResource.setTargetBean(target);
        tccResource.setPrepareMethod(m);
        tccResource.setCommitMethodName(twoPhaseBusinessAction.commitMethod());
        tccResource.setCommitMethod(targetServiceClass.getMethod(twoPhaseBusinessAction.commitMethod(), twoPhaseBusinessAction.commitArgsClasses()));
        tccResource.setRollbackMethodName(twoPhaseBusinessAction.rollbackMethod());
        tccResource.setRollbackMethod(targetServiceClass.getMethod(twoPhaseBusinessAction.rollbackMethod(), twoPhaseBusinessAction.rollbackArgsClasses()));
        tccResource.setCommitArgsClasses(twoPhaseBusinessAction.commitArgsClasses());
        tccResource.setRollbackArgsClasses(twoPhaseBusinessAction.rollbackArgsClasses());
        tccResource.setPhaseTwoCommitKeys(ActionContextUtil.getTwoPhaseArgs(tccResource.getCommitMethod(), twoPhaseBusinessAction.commitArgsClasses()));
        tccResource.setPhaseTwoRollbackKeys(ActionContextUtil.getTwoPhaseArgs(tccResource.getRollbackMethod(), twoPhaseBusinessAction.rollbackArgsClasses()));
        return tccResource;
    }
}

