/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.rm;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seata.common.exception.ExceptionUtil;
import org.apache.seata.common.exception.RepeatRegistrationException;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.model.BranchStatus;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.core.model.Resource;
import org.apache.seata.integration.tx.api.remoting.TwoPhaseResult;
import org.apache.seata.rm.AbstractResourceManager;
import org.apache.seata.rm.tcc.api.BusinessActionContext;
import org.apache.seata.rm.tcc.api.BusinessActionContextUtil;
import org.apache.seata.saga.rm.SagaAnnotationResource;

public class SagaAnnotationResourceManager
extends AbstractResourceManager {
    private final Map<String, Resource> resourceCache = new ConcurrentHashMap<String, Resource>();

    @Override
    public void registerResource(Resource resource) {
        Object oldResourceBean;
        Object newResourceBean;
        String resourceId = resource.getResourceId();
        SagaAnnotationResource newResource = (SagaAnnotationResource)resource;
        SagaAnnotationResource oldResource = (SagaAnnotationResource)this.resourceCache.get(resourceId);
        if (oldResource != null && (newResourceBean = newResource.getTargetBean()) != (oldResourceBean = oldResource.getTargetBean())) {
            throw new RepeatRegistrationException(String.format("Same SagaAnnotation resource name <%s> between method1 <%s> of class1 <%s> and method2 <%s> of class2 <%s>, should be unique", resourceId, newResource.getActionName(), newResourceBean.getClass().getName(), oldResource.getActionName(), oldResourceBean.getClass().getName()));
        }
        this.resourceCache.put(resourceId, newResource);
        super.registerResource(newResource);
    }

    @Override
    public BranchStatus branchCommit(BranchType branchType, String xid, long branchId, String resourceId, String applicationData) {
        return BranchStatus.PhaseTwo_Committed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BranchStatus branchRollback(BranchType branchType, String xid, long branchId, String resourceId, String applicationData) throws TransactionException {
        SagaAnnotationResource resource = (SagaAnnotationResource)this.resourceCache.get(resourceId);
        if (resource == null) {
            throw new ShouldNeverHappenException(String.format("SagaAnnotation resource is not exist, resourceId: %s", resourceId));
        }
        Object targetBean = resource.getTargetBean();
        Method compensationMethod = resource.getCompensationMethod();
        if (targetBean == null || compensationMethod == null) {
            throw new ShouldNeverHappenException(String.format("SagaAnnotation resource is not available, resourceId: %s", resourceId));
        }
        try {
            BusinessActionContext businessActionContext = BusinessActionContextUtil.getBusinessActionContext(xid, branchId, resourceId, applicationData);
            Object[] args = this.getTwoPhaseRollbackArgs(resource, businessActionContext);
            BusinessActionContextUtil.setContext(businessActionContext);
            Object ret = compensationMethod.invoke(targetBean, args);
            boolean result = ret != null ? (ret instanceof TwoPhaseResult ? ((TwoPhaseResult)ret).isSuccess() : ((Boolean)ret).booleanValue()) : true;
            LOGGER.info("SagaAnnotation resource rollback result : {}, xid: {}, branchId: {}, resourceId: {}", new Object[]{result, xid, branchId, resourceId});
            BranchStatus branchStatus = result ? BranchStatus.PhaseTwo_Rollbacked : BranchStatus.PhaseTwo_RollbackFailed_Retryable;
            return branchStatus;
        }
        catch (Throwable t) {
            String msg = String.format("rollback SagaAnnotation resource error, resourceId: %s, xid: %s.", resourceId, xid);
            LOGGER.error(msg, ExceptionUtil.unwrap(t));
            BranchStatus branchStatus = BranchStatus.PhaseTwo_RollbackFailed_Retryable;
            return branchStatus;
        }
        finally {
            BusinessActionContextUtil.clear();
        }
    }

    @Override
    public Map<String, Resource> getManagedResources() {
        return this.resourceCache;
    }

    @Override
    public BranchType getBranchType() {
        return BranchType.SAGA_ANNOTATION;
    }

    private Object[] getTwoPhaseRollbackArgs(SagaAnnotationResource resource, BusinessActionContext businessActionContext) {
        String[] keys = resource.getPhaseTwoCompensationKeys();
        Class<?>[] argsRollbackClasses = resource.getCompensationArgsClasses();
        return this.getTwoPhaseMethodParams(keys, argsRollbackClasses, businessActionContext);
    }

    protected Object[] getTwoPhaseMethodParams(String[] keys, Class<?>[] argsClasses, BusinessActionContext businessActionContext) {
        Object[] args = new Object[argsClasses.length];
        for (int i = 0; i < argsClasses.length; ++i) {
            args[i] = argsClasses[i].equals(BusinessActionContext.class) ? businessActionContext : businessActionContext.getActionContext(keys[i], argsClasses[i]);
        }
        return args;
    }
}

