/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.sqlparser.druid.postgresql;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGInsertStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGUpdateStatement;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.seata.common.exception.NotSupportYetException;
import org.apache.seata.sqlparser.ParametersHolder;
import org.apache.seata.sqlparser.druid.BaseRecognizer;
import org.apache.seata.sqlparser.struct.Null;

public abstract class BasePostgresqlRecognizer
extends BaseRecognizer {
    public BasePostgresqlRecognizer(String originalSql) {
        super(originalSql);
    }

    public PGOutputVisitor createOutputVisitor(final ParametersHolder parametersHolder, final ArrayList<List<Object>> paramAppenderList, StringBuilder sb) {
        PGOutputVisitor visitor = new PGOutputVisitor(sb){

            public boolean visit(SQLVariantRefExpr x) {
                if ("?".equals(x.getName())) {
                    ArrayList<Object> oneParamValues = parametersHolder.getParameters().get(x.getIndex() + 1);
                    if (paramAppenderList.size() == 0) {
                        oneParamValues.forEach(t -> paramAppenderList.add(new ArrayList()));
                    }
                    for (int i = 0; i < oneParamValues.size(); ++i) {
                        Object o = oneParamValues.get(i);
                        ((List)paramAppenderList.get(i)).add(o instanceof Null ? null : o);
                    }
                }
                return super.visit(x);
            }
        };
        return visitor;
    }

    @Override
    public boolean isSqlSyntaxSupports() {
        PGASTVisitorAdapter visitor = new PGASTVisitorAdapter(){

            public boolean visit(SQLSubqueryTableSource x) {
                throw new NotSupportYetException("not support the sql syntax with SubQuery:" + x + "\nplease see the doc about SQL restrictions https://seata.apache.org/zh-cn/docs/user/sqlreference/dml");
            }

            public boolean visit(PGUpdateStatement x) {
                if (x.getFrom() != null) {
                    throw new NotSupportYetException("not support the sql syntax with join table:" + x + "\nplease see the doc about SQL restrictions https://seata.apache.org/zh-cn/docs/user/sqlreference/dml");
                }
                return true;
            }

            public boolean visit(SQLInSubQueryExpr x) {
                throw new NotSupportYetException("not support the sql syntax with InSubQuery:" + x + "\nplease see the doc about SQL restrictions https://seata.apache.org/zh-cn/docs/user/sqlreference/dml");
            }

            public boolean visit(PGInsertStatement x) {
                if (null != x.getQuery()) {
                    throw new NotSupportYetException("not support the sql syntax insert with query:" + x + "\nplease see the doc about SQL restrictions https://seata.apache.org/zh-cn/docs/user/sqlreference/dml");
                }
                return true;
            }
        };
        this.getAst().accept((SQLASTVisitor)visitor);
        return true;
    }

    public String getWhereCondition(SQLExpr where, ParametersHolder parametersHolder, ArrayList<List<Object>> paramAppenderList) {
        if (Objects.isNull(where)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.executeVisit(where, (SQLASTVisitor)this.createOutputVisitor(parametersHolder, paramAppenderList, sb));
        return sb.toString();
    }

    public String getWhereCondition(SQLExpr where) {
        if (Objects.isNull(where)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.executeVisit(where, (SQLASTVisitor)new PGOutputVisitor((Appendable)sb));
        return sb.toString();
    }

    protected String getLimitCondition(SQLLimit sqlLimit) {
        if (Objects.isNull(sqlLimit)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.executeLimit(sqlLimit, (SQLASTVisitor)new PGOutputVisitor((Appendable)sb));
        return sb.toString();
    }

    protected String getLimitCondition(SQLLimit sqlLimit, ParametersHolder parametersHolder, ArrayList<List<Object>> paramAppenderList) {
        if (Objects.isNull(sqlLimit)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.executeLimit(sqlLimit, (SQLASTVisitor)this.createOutputVisitor(parametersHolder, paramAppenderList, sb));
        return sb.toString();
    }

    protected String getOrderByCondition(SQLOrderBy sqlOrderBy) {
        if (Objects.isNull(sqlOrderBy)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.executeOrderBy(sqlOrderBy, (SQLASTVisitor)new PGOutputVisitor((Appendable)sb));
        return sb.toString();
    }

    protected String getOrderByCondition(SQLOrderBy sqlOrderBy, ParametersHolder parametersHolder, ArrayList<List<Object>> paramAppenderList) {
        if (Objects.isNull(sqlOrderBy)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.executeOrderBy(sqlOrderBy, (SQLASTVisitor)this.createOutputVisitor(parametersHolder, paramAppenderList, sb));
        return sb.toString();
    }

    public String getDbType() {
        return "postgresql";
    }
}

