/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.exception;

import java.sql.SQLException;
import org.apache.seata.common.exception.ErrorCode;

public class SeataRuntimeException
extends RuntimeException {
    private int vendorCode;
    private String sqlState;

    public SeataRuntimeException(ErrorCode errorCode, String ... params) {
        super(errorCode.getMessage(params));
        this.vendorCode = errorCode.getCode();
    }

    public SeataRuntimeException(ErrorCode errorCode, Throwable cause, String ... params) {
        super(errorCode.getMessage(params), cause);
        this.buildSQLMessage(cause);
    }

    @Override
    public String toString() {
        return super.getLocalizedMessage();
    }

    @Override
    public String getMessage() {
        if (super.getMessage() != null) {
            return super.getMessage();
        }
        if (this.getCause() != null) {
            Throwable ca = this.getCause();
            if (ca != null) {
                return ca.getMessage();
            }
            return null;
        }
        return null;
    }

    private void buildSQLMessage(Throwable e) {
        if (e instanceof SQLException) {
            this.vendorCode = ((SQLException)e).getErrorCode();
            this.sqlState = ((SQLException)e).getSQLState();
        } else if (e instanceof SeataRuntimeException) {
            this.vendorCode = ((SeataRuntimeException)e).getVendorCode();
            this.sqlState = ((SeataRuntimeException)e).getSqlState();
        }
    }

    public int getVendorCode() {
        return this.vendorCode;
    }

    public String getSqlState() {
        return this.sqlState;
    }
}

