/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.tm.api;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.seata.common.thread.NamedThreadFactory;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.logger.StackTraceLogger;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.tm.api.GlobalTransaction;
import org.apache.seata.tm.api.TMFailureHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFailureHandlerImpl
implements TMFailureHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFailureHandlerImpl.class);
    private static final int RETRY_MAX_TIMES = 360;
    private static final long SCHEDULE_INTERVAL_SECONDS = 10L;
    private static final long TICK_DURATION = 1L;
    private static final int TICKS_PER_WHEEL = 8;
    private static final HashedWheelTimer TIMER = new HashedWheelTimer((ThreadFactory)new NamedThreadFactory("failedTransactionRetry", 1), 1L, TimeUnit.SECONDS, 8);

    @Override
    public void onBeginFailure(GlobalTransaction tx, Throwable cause) {
        LOGGER.warn("Failed to begin transaction. ", cause);
    }

    @Override
    public void onCommitFailure(GlobalTransaction tx, Throwable cause) {
        LOGGER.warn("Failed to commit transaction[" + tx.getXid() + "]", cause);
        TIMER.newTimeout((TimerTask)new CheckTimerTask(tx, GlobalStatus.Committed), 10L, TimeUnit.SECONDS);
    }

    @Override
    public void onRollbackFailure(GlobalTransaction tx, Throwable originalException) {
        LOGGER.warn("Failed to rollback transaction[" + tx.getXid() + "]", originalException);
        TIMER.newTimeout((TimerTask)new CheckTimerTask(tx, GlobalStatus.Rollbacked), 10L, TimeUnit.SECONDS);
    }

    @Override
    public void onRollbacking(GlobalTransaction tx, Throwable originalException) {
        StackTraceLogger.warn((Logger)LOGGER, (Throwable)originalException, (String)"Retrying to rollback transaction[{}]", (Object[])new String[]{tx.getXid()});
        TIMER.newTimeout((TimerTask)new CheckTimerTask(tx, GlobalStatus.RollbackRetrying), 10L, TimeUnit.SECONDS);
    }

    private boolean shouldStop(GlobalTransaction tx, GlobalStatus required) {
        try {
            GlobalStatus status = tx.getStatus();
            LOGGER.info("transaction [{}] current status is [{}]", (Object)tx.getXid(), (Object)status);
            if (status == required || status == GlobalStatus.Finished) {
                return true;
            }
        }
        catch (TransactionException e) {
            LOGGER.error("fetch GlobalTransaction status error", (Throwable)e);
        }
        return false;
    }

    protected class CheckTimerTask
    implements TimerTask {
        private final GlobalTransaction tx;
        private final GlobalStatus required;
        private int count = 0;
        private boolean isStopped = false;

        protected CheckTimerTask(GlobalTransaction tx, GlobalStatus required) {
            this.tx = tx;
            this.required = required;
        }

        public void run(Timeout timeout) throws Exception {
            if (!this.isStopped) {
                if (++this.count > 360) {
                    LOGGER.error("transaction [{}] retry fetch status times exceed the limit [{} times]", (Object)this.tx.getXid(), (Object)360);
                    return;
                }
                this.isStopped = DefaultFailureHandlerImpl.this.shouldStop(this.tx, this.required);
                TIMER.newTimeout((TimerTask)this, 10L, TimeUnit.SECONDS);
            }
        }
    }
}

