/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.tm.api;

import java.util.List;
import org.apache.seata.common.exception.FrameworkErrorCode;
import org.apache.seata.common.exception.FrameworkException;
import org.apache.seata.core.context.GlobalLockConfigHolder;
import org.apache.seata.core.exception.TmTransactionException;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.exception.TransactionExceptionCode;
import org.apache.seata.core.model.GlobalLockConfig;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.tm.api.GlobalTransaction;
import org.apache.seata.tm.api.GlobalTransactionRole;
import org.apache.seata.tm.api.TransactionalExecutor;
import org.apache.seata.tm.api.transaction.TransactionHook;
import org.apache.seata.tm.api.transaction.TransactionHookManager;
import org.apache.seata.tm.api.transaction.TransactionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalTemplate.class);

    /*
     * Exception decompiling
     */
    public Object execute(TransactionalExecutor business) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isTimeout(long beginTime, TransactionInfo txInfo) {
        return System.currentTimeMillis() - beginTime > (long)txInfo.getTimeOut();
    }

    private boolean existingTransaction(GlobalTransaction tx) {
        return tx != null;
    }

    private boolean notExistingTransaction(GlobalTransaction tx) {
        return tx == null;
    }

    private GlobalLockConfig replaceGlobalLockConfig(TransactionInfo info) {
        GlobalLockConfig myConfig = new GlobalLockConfig();
        myConfig.setLockRetryInterval(info.getLockRetryInterval());
        myConfig.setLockRetryTimes(info.getLockRetryTimes());
        myConfig.setLockStrategyMode(info.getLockStrategyMode());
        return GlobalLockConfigHolder.setAndReturnPrevious((GlobalLockConfig)myConfig);
    }

    private void resumeGlobalLockConfig(GlobalLockConfig config) {
        if (config != null) {
            GlobalLockConfigHolder.setAndReturnPrevious((GlobalLockConfig)config);
        } else {
            GlobalLockConfigHolder.remove();
        }
    }

    private void completeTransactionAfterThrowing(TransactionInfo txInfo, GlobalTransaction tx, Throwable originalException) throws TransactionalExecutor.ExecutionException, TransactionException {
        if (txInfo != null && txInfo.rollbackOn(originalException)) {
            this.rollbackTransaction(tx, originalException);
        } else {
            this.commitTransaction(tx, txInfo);
        }
    }

    private void commitTransaction(GlobalTransaction tx, TransactionInfo txInfo) throws TransactionalExecutor.ExecutionException, TransactionException {
        if (tx.getGlobalTransactionRole() != GlobalTransactionRole.Launcher) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ignore commit: just involved in global transaction [{}]", (Object)tx.getXid());
            }
            return;
        }
        if (this.isTimeout(tx.getCreateTime(), txInfo)) {
            TmTransactionException exx = new TmTransactionException(TransactionExceptionCode.TransactionTimeout, String.format("client detected transaction timeout before commit, so change to rollback, xid = %s", tx.getXid()));
            this.rollbackTransaction(tx, (Throwable)exx);
            return;
        }
        try {
            this.triggerBeforeCommit();
            tx.commit();
            GlobalStatus afterCommitStatus = tx.getLocalStatus();
            TransactionalExecutor.Code code = TransactionalExecutor.Code.Unknown;
            switch (afterCommitStatus) {
                case TimeoutRollbacking: {
                    code = TransactionalExecutor.Code.Rollbacking;
                    break;
                }
                case TimeoutRollbacked: {
                    code = TransactionalExecutor.Code.RollbackDone;
                    break;
                }
                case Finished: {
                    code = TransactionalExecutor.Code.CommitFailure;
                    break;
                }
            }
            TmTransactionException statusException = null;
            if (GlobalStatus.isTwoPhaseHeuristic((GlobalStatus)afterCommitStatus)) {
                statusException = new TmTransactionException(TransactionExceptionCode.CommitHeuristic, String.format("Global transaction[%s] not found, may be rollbacked.", tx.getXid()));
            } else if (GlobalStatus.isOnePhaseTimeout((GlobalStatus)afterCommitStatus)) {
                statusException = new TmTransactionException(TransactionExceptionCode.TransactionTimeout, String.format("Global transaction[%s] is timeout and will be rollback[TC].", tx.getXid()));
            }
            if (null != statusException) {
                throw new TransactionalExecutor.ExecutionException(tx, (Throwable)statusException, code);
            }
            this.triggerAfterCommit();
        }
        catch (TransactionException txe) {
            throw new TransactionalExecutor.ExecutionException(tx, txe, TransactionalExecutor.Code.CommitFailure);
        }
    }

    private void rollbackTransaction(GlobalTransaction tx, Throwable originalException) throws TransactionException, TransactionalExecutor.ExecutionException {
        TransactionalExecutor.Code code;
        if (tx.getGlobalTransactionRole() != GlobalTransactionRole.Launcher) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ignore rollback: just involved in global transaction [{}]", (Object)tx.getXid());
            }
            return;
        }
        try {
            this.triggerBeforeRollback();
            tx.rollback();
            this.triggerAfterRollback();
        }
        catch (TransactionException txe) {
            throw new TransactionalExecutor.ExecutionException(tx, (Throwable)txe, TransactionalExecutor.Code.RollbackFailure, originalException);
        }
        switch (tx.getLocalStatus()) {
            case RollbackFailed: 
            case TimeoutRollbackFailed: 
            case RollbackRetryTimeout: {
                code = TransactionalExecutor.Code.RollbackFailure;
                break;
            }
            case TimeoutRollbacking: 
            case Rollbacking: 
            case RollbackRetrying: 
            case TimeoutRollbackRetrying: {
                code = TransactionalExecutor.Code.Rollbacking;
                break;
            }
            case TimeoutRollbacked: 
            case Finished: 
            case Rollbacked: {
                code = TransactionalExecutor.Code.RollbackDone;
                break;
            }
            default: {
                code = TransactionalExecutor.Code.Unknown;
                LOGGER.warn("{} rollback in the state {}", (Object)tx.getXid(), (Object)tx.getLocalStatus());
            }
        }
        throw new TransactionalExecutor.ExecutionException(tx, code, originalException);
    }

    private void beginTransaction(TransactionInfo txInfo, GlobalTransaction tx) throws TransactionalExecutor.ExecutionException {
        if (tx.getGlobalTransactionRole() != GlobalTransactionRole.Launcher) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ignore begin: just involved in global transaction [{}]", (Object)tx.getXid());
            }
            return;
        }
        try {
            this.triggerBeforeBegin();
            tx.begin(txInfo.getTimeOut(), txInfo.getName());
            this.triggerAfterBegin();
        }
        catch (TransactionException txe) {
            throw new TransactionalExecutor.ExecutionException(tx, txe, TransactionalExecutor.Code.BeginFailure);
        }
    }

    private void triggerBeforeBegin() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.beforeBegin();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute beforeBegin in hook {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void triggerAfterBegin() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.afterBegin();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute afterBegin in hook {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void triggerBeforeRollback() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.beforeRollback();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute beforeRollback in hook {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void triggerAfterRollback() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.afterRollback();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute afterRollback in hook {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void triggerBeforeCommit() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.beforeCommit();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute beforeCommit in hook {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void triggerAfterCommit() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.afterCommit();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute afterCommit in hook {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void triggerAfterCompletion(GlobalTransaction tx) {
        if (tx == null || tx.getGlobalTransactionRole() == GlobalTransactionRole.Launcher) {
            for (TransactionHook hook : this.getCurrentHooks()) {
                try {
                    hook.afterCompletion();
                }
                catch (Exception e) {
                    LOGGER.error("Failed execute afterCompletion in hook {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    private void cleanUp(GlobalTransaction tx) {
        if (tx == null) {
            throw new FrameworkException("Global transaction does not exist. Unable to proceed without a valid global transaction context.", FrameworkErrorCode.ObjectNotExists);
        }
        if (tx.getGlobalTransactionRole() == GlobalTransactionRole.Launcher) {
            TransactionHookManager.clear();
        }
    }

    private List<TransactionHook> getCurrentHooks() {
        return TransactionHookManager.getHooks();
    }
}

