/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.checkpoint.storage.hdfs.common;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.seatunnel.engine.checkpoint.storage.hdfs.common.AbstractConfiguration;

public class OssConfiguration
extends AbstractConfiguration {
    public static final String OSS_BUCKET_KEY = "oss.bucket";
    private static final String OSS_IMPL_KEY = "fs.oss.impl";
    private static final String HDFS_OSS_IMPL = "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem";
    private static final String OSS_KEY = "fs.oss.";

    @Override
    public Configuration buildConfiguration(Map<String, String> config) {
        this.checkConfiguration(config, OSS_BUCKET_KEY);
        Configuration hadoopConf = new Configuration();
        hadoopConf.set("fs.defaultFS", config.get(OSS_BUCKET_KEY));
        hadoopConf.set(OSS_IMPL_KEY, HDFS_OSS_IMPL);
        hadoopConf.setBoolean(String.format("%s.disable.cache", OSS_IMPL_KEY), Boolean.parseBoolean(config.getOrDefault("disable.cache", "TRUE")));
        this.setExtraConfiguration(hadoopConf, config, OSS_KEY);
        return hadoopConf;
    }
}

