/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.activemq.config;

import java.io.Serializable;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;

public class ActivemqSinkOptions
implements Serializable {
    public static final Option<String> USERNAME = Options.key((String)"username").stringType().noDefaultValue().withDescription("the AMQP user name to use when connecting to the broker");
    public static final Option<String> PASSWORD = Options.key((String)"password").stringType().noDefaultValue().withDescription("the password to use when connecting to the broker");
    public static final Option<String> QUEUE_NAME = Options.key((String)"queue_name").stringType().noDefaultValue().withDescription("the queue to write the message to");
    public static final Option<String> URI = Options.key((String)"uri").stringType().noDefaultValue().withDescription("convenience method for setting the fields in an AMQP URI: host, port, username, password and virtual host");
    public static final Option<Boolean> CHECK_FOR_DUPLICATE = Options.key((String)"check_for_duplicate").booleanType().noDefaultValue().withDescription("When true the consumer will check for duplicate messages and properly handle +the message to make sure that it is not processed twice inadvertently.");
    public static final Option<String> CLIENT_ID = Options.key((String)"client_id").stringType().noDefaultValue().withDescription("Sets the JMS clientID to use for the connection.");
    public static final Option<Boolean> ALWAYS_SESSION_ASYNC = Options.key((String)"always_session_async").booleanType().noDefaultValue().withDescription("When true a separate thread is used for dispatching messages for each Session in the Connection. A separate thread is always used when there\u2019s more than one session, or the session isn\u2019t in Session.AUTO_ACKNOWLEDGE or Session.DUPS_OK_ACKNOWLEDGE mode.");
    public static final Option<Boolean> ALWAYS_SYNC_SEND = Options.key((String)"always_sync_send").booleanType().noDefaultValue().withDescription("When true a MessageProducer will always use Sync sends when sending a Message even if it is not required for the Delivery Mode.");
    public static final Option<Integer> CLOSE_TIMEOUT = Options.key((String)"close_timeout").intType().noDefaultValue().withDescription("Sets the timeout, in milliseconds, before a close is considered complete. Normally a close() on a connection waits for confirmation from the broker. This allows the close operation to timeout preventing the client from hanging when no broker is available.");
    public static final Option<Boolean> DISPATCH_ASYNC = Options.key((String)"dispatch_async").booleanType().noDefaultValue().withDescription("Should the broker dispatch messages asynchronously to the consumer?");
    public static final Option<Boolean> NESTED_MAP_AND_LIST_ENABLED = Options.key((String)"nested_map_and_list_enabled").booleanType().noDefaultValue().withDescription("Controls whether Structured Message Properties and MapMessages are supported so that Message properties and MapMessage entries can contain nested Map and List objects. Available from version 4.1.");
    public static final Option<Integer> WARN_ABOUT_UNSTARTED_CONNECTION_TIMEOUT = Options.key((String)"warn_about_unstarted_connection_timeout").intType().noDefaultValue().withDescription("The timeout, in milliseconds, from the time of connection creation to when a warning is generated if the connection is not properly started via Connection.start() and a message is received by a consumer. It is a very common gotcha to forget to start the connection and then wonder why no messages are delivered so this option makes the default case to create a warning if the user forgets. To disable the warning just set the value to < 0.");
    public static final Option<Boolean> CONSUMER_EXPIRY_CHECK_ENABLED = Options.key((String)"consumer_expiry_check_enabled").booleanType().noDefaultValue().withDescription("Controls whether message expiration checking is done in each MessageConsumer prior to dispatching a message.");
}

