/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.assertion.rule;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.connectors.seatunnel.assertion.rule.AssertFieldRule;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class AssertRuleParser {
    private static final Map<String, SeaTunnelDataType<?>> TYPES = Maps.newHashMap();

    public List<AssertFieldRule.AssertRule> parseRowRules(List<? extends Config> rowRuleList) {
        return this.assembleFieldValueRules(rowRuleList);
    }

    public List<AssertFieldRule> parseRules(List<? extends Config> ruleConfigList) {
        return ruleConfigList.stream().map(config -> {
            AssertFieldRule fieldRule = new AssertFieldRule();
            fieldRule.setFieldName(config.getString("field_name"));
            if (config.hasPath("field_type")) {
                fieldRule.setFieldType(this.getFieldType(config.getString("field_type")));
            }
            if (config.hasPath("field_value")) {
                List<AssertFieldRule.AssertRule> fieldValueRules = this.assembleFieldValueRules(config.getConfigList("field_value"));
                fieldRule.setFieldRules(fieldValueRules);
            }
            return fieldRule;
        }).collect(Collectors.toList());
    }

    private List<AssertFieldRule.AssertRule> assembleFieldValueRules(List<? extends Config> fieldValueConfigList) {
        return fieldValueConfigList.stream().map(config -> {
            AssertFieldRule.AssertRule valueRule = new AssertFieldRule.AssertRule();
            if (config.hasPath("rule_type")) {
                valueRule.setRuleType(AssertFieldRule.AssertRuleType.valueOf(config.getString("rule_type")));
            }
            if (config.hasPath("rule_value")) {
                valueRule.setRuleValue(config.getDouble("rule_value"));
            }
            return valueRule;
        }).collect(Collectors.toList());
    }

    private SeaTunnelDataType<?> getFieldType(String fieldTypeStr) {
        return TYPES.get(fieldTypeStr.toLowerCase());
    }

    static {
        TYPES.put("string", (SeaTunnelDataType<?>)BasicType.STRING_TYPE);
        TYPES.put("boolean", (SeaTunnelDataType<?>)BasicType.BOOLEAN_TYPE);
        TYPES.put("byte", (SeaTunnelDataType<?>)BasicType.BYTE_TYPE);
        TYPES.put("short", (SeaTunnelDataType<?>)BasicType.SHORT_TYPE);
        TYPES.put("int", (SeaTunnelDataType<?>)BasicType.INT_TYPE);
        TYPES.put("long", (SeaTunnelDataType<?>)BasicType.LONG_TYPE);
        TYPES.put("float", (SeaTunnelDataType<?>)BasicType.FLOAT_TYPE);
        TYPES.put("double", (SeaTunnelDataType<?>)BasicType.DOUBLE_TYPE);
        TYPES.put("void", (SeaTunnelDataType<?>)BasicType.VOID_TYPE);
    }
}

