/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.assertion.rule;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.configuration.util.OptionMark;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.assertion.exception.AssertConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.assertion.exception.AssertConnectorException;

public class AssertCatalogTableRule
implements Serializable {
    @OptionMark(description="assert primary key rule")
    private AssertPrimaryKeyRule primaryKeyRule;
    @OptionMark(description="constraint key rule")
    private AssertConstraintKeyRule constraintKeyRule;
    @OptionMark(description="column rule")
    private AssertColumnRule columnRule;
    @OptionMark(description="tableIdentifier rule")
    private AssertTableIdentifierRule tableIdentifierRule;

    public void checkRule(CatalogTable catalogTable) {
        TableSchema tableSchema = catalogTable.getTableSchema();
        if (tableSchema == null) {
            throw new AssertConnectorException((SeaTunnelErrorCode)AssertConnectorErrorCode.CATALOG_TABLE_FAILED, "tableSchema is null");
        }
        if (this.primaryKeyRule != null) {
            this.primaryKeyRule.checkRule(tableSchema.getPrimaryKey());
        }
        if (this.constraintKeyRule != null) {
            this.constraintKeyRule.checkRule(tableSchema.getConstraintKeys());
        }
        if (this.columnRule != null) {
            this.columnRule.checkRule(tableSchema.getColumns());
        }
        if (this.tableIdentifierRule != null) {
            this.tableIdentifierRule.checkRule(catalogTable.getTableId());
        }
    }

    private static boolean isColumnEqual(Column column1, Column column2) {
        return Objects.equals(column1.getName(), column2.getName()) && Objects.equals(column1.getDataType(), column2.getDataType()) && Objects.equals(column1.getColumnLength(), column2.getColumnLength()) && Objects.equals(column1.getScale(), column2.getScale()) && column1.isNullable() == column2.isNullable() && Objects.equals(column1.getDefaultValue(), column2.getDefaultValue()) && Objects.equals(column1.getComment(), column2.getComment()) && Objects.equals(column1.getSourceType(), column2.getSourceType());
    }

    public AssertPrimaryKeyRule getPrimaryKeyRule() {
        return this.primaryKeyRule;
    }

    public AssertConstraintKeyRule getConstraintKeyRule() {
        return this.constraintKeyRule;
    }

    public AssertColumnRule getColumnRule() {
        return this.columnRule;
    }

    public AssertTableIdentifierRule getTableIdentifierRule() {
        return this.tableIdentifierRule;
    }

    public void setPrimaryKeyRule(AssertPrimaryKeyRule primaryKeyRule) {
        this.primaryKeyRule = primaryKeyRule;
    }

    public void setConstraintKeyRule(AssertConstraintKeyRule constraintKeyRule) {
        this.constraintKeyRule = constraintKeyRule;
    }

    public void setColumnRule(AssertColumnRule columnRule) {
        this.columnRule = columnRule;
    }

    public void setTableIdentifierRule(AssertTableIdentifierRule tableIdentifierRule) {
        this.tableIdentifierRule = tableIdentifierRule;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssertCatalogTableRule)) {
            return false;
        }
        AssertCatalogTableRule other = (AssertCatalogTableRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AssertPrimaryKeyRule this$primaryKeyRule = this.getPrimaryKeyRule();
        AssertPrimaryKeyRule other$primaryKeyRule = other.getPrimaryKeyRule();
        if (this$primaryKeyRule == null ? other$primaryKeyRule != null : !((Object)this$primaryKeyRule).equals(other$primaryKeyRule)) {
            return false;
        }
        AssertConstraintKeyRule this$constraintKeyRule = this.getConstraintKeyRule();
        AssertConstraintKeyRule other$constraintKeyRule = other.getConstraintKeyRule();
        if (this$constraintKeyRule == null ? other$constraintKeyRule != null : !((Object)this$constraintKeyRule).equals(other$constraintKeyRule)) {
            return false;
        }
        AssertColumnRule this$columnRule = this.getColumnRule();
        AssertColumnRule other$columnRule = other.getColumnRule();
        if (this$columnRule == null ? other$columnRule != null : !((Object)this$columnRule).equals(other$columnRule)) {
            return false;
        }
        AssertTableIdentifierRule this$tableIdentifierRule = this.getTableIdentifierRule();
        AssertTableIdentifierRule other$tableIdentifierRule = other.getTableIdentifierRule();
        return !(this$tableIdentifierRule == null ? other$tableIdentifierRule != null : !((Object)this$tableIdentifierRule).equals(other$tableIdentifierRule));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssertCatalogTableRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AssertPrimaryKeyRule $primaryKeyRule = this.getPrimaryKeyRule();
        result = result * 59 + ($primaryKeyRule == null ? 43 : ((Object)$primaryKeyRule).hashCode());
        AssertConstraintKeyRule $constraintKeyRule = this.getConstraintKeyRule();
        result = result * 59 + ($constraintKeyRule == null ? 43 : ((Object)$constraintKeyRule).hashCode());
        AssertColumnRule $columnRule = this.getColumnRule();
        result = result * 59 + ($columnRule == null ? 43 : ((Object)$columnRule).hashCode());
        AssertTableIdentifierRule $tableIdentifierRule = this.getTableIdentifierRule();
        result = result * 59 + ($tableIdentifierRule == null ? 43 : ((Object)$tableIdentifierRule).hashCode());
        return result;
    }

    public String toString() {
        return "AssertCatalogTableRule(primaryKeyRule=" + this.getPrimaryKeyRule() + ", constraintKeyRule=" + this.getConstraintKeyRule() + ", columnRule=" + this.getColumnRule() + ", tableIdentifierRule=" + this.getTableIdentifierRule() + ")";
    }

    public static class AssertPrimaryKeyRule
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @OptionMark(description="primary key name")
        private String primaryKeyName;
        @OptionMark(description="primary key columns")
        private List<String> primaryKeyColumns;

        public void checkRule(PrimaryKey check) {
            if (check == null) {
                throw new AssertConnectorException((SeaTunnelErrorCode)AssertConnectorErrorCode.CATALOG_TABLE_FAILED, "primaryKey is null");
            }
            if (this.primaryKeyName != null && !this.primaryKeyName.equals(check.getPrimaryKey())) {
                throw new AssertConnectorException((SeaTunnelErrorCode)AssertConnectorErrorCode.CATALOG_TABLE_FAILED, String.format("primaryKey: %s is not equal to %s", check.getPrimaryKey(), this.primaryKeyName));
            }
            if (CollectionUtils.isNotEmpty(this.primaryKeyColumns) && !CollectionUtils.isEqualCollection(this.primaryKeyColumns, (Collection)check.getColumnNames())) {
                throw new AssertConnectorException((SeaTunnelErrorCode)AssertConnectorErrorCode.CATALOG_TABLE_FAILED, String.format("primaryKey columns: %s is not equal to %s", check.getColumnNames(), this.primaryKeyColumns));
            }
        }

        public String getPrimaryKeyName() {
            return this.primaryKeyName;
        }

        public List<String> getPrimaryKeyColumns() {
            return this.primaryKeyColumns;
        }

        public void setPrimaryKeyName(String primaryKeyName) {
            this.primaryKeyName = primaryKeyName;
        }

        public void setPrimaryKeyColumns(List<String> primaryKeyColumns) {
            this.primaryKeyColumns = primaryKeyColumns;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssertPrimaryKeyRule)) {
                return false;
            }
            AssertPrimaryKeyRule other = (AssertPrimaryKeyRule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$primaryKeyName = this.getPrimaryKeyName();
            String other$primaryKeyName = other.getPrimaryKeyName();
            if (this$primaryKeyName == null ? other$primaryKeyName != null : !this$primaryKeyName.equals(other$primaryKeyName)) {
                return false;
            }
            List<String> this$primaryKeyColumns = this.getPrimaryKeyColumns();
            List<String> other$primaryKeyColumns = other.getPrimaryKeyColumns();
            return !(this$primaryKeyColumns == null ? other$primaryKeyColumns != null : !((Object)this$primaryKeyColumns).equals(other$primaryKeyColumns));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AssertPrimaryKeyRule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $primaryKeyName = this.getPrimaryKeyName();
            result = result * 59 + ($primaryKeyName == null ? 43 : $primaryKeyName.hashCode());
            List<String> $primaryKeyColumns = this.getPrimaryKeyColumns();
            result = result * 59 + ($primaryKeyColumns == null ? 43 : ((Object)$primaryKeyColumns).hashCode());
            return result;
        }

        public String toString() {
            return "AssertCatalogTableRule.AssertPrimaryKeyRule(primaryKeyName=" + this.getPrimaryKeyName() + ", primaryKeyColumns=" + this.getPrimaryKeyColumns() + ")";
        }

        public AssertPrimaryKeyRule() {
        }

        public AssertPrimaryKeyRule(String primaryKeyName, List<String> primaryKeyColumns) {
            this.primaryKeyName = primaryKeyName;
            this.primaryKeyColumns = primaryKeyColumns;
        }
    }

    public static class AssertConstraintKeyRule
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<ConstraintKey> constraintKeys;

        public void checkRule(List<ConstraintKey> check) {
            if (CollectionUtils.isEmpty(check)) {
                throw new AssertConnectorException((SeaTunnelErrorCode)AssertConnectorErrorCode.CATALOG_TABLE_FAILED, "constraintKeys is null");
            }
            if (CollectionUtils.isNotEmpty(this.constraintKeys) && !CollectionUtils.isEqualCollection(this.constraintKeys, check)) {
                throw new AssertConnectorException((SeaTunnelErrorCode)AssertConnectorErrorCode.CATALOG_TABLE_FAILED, String.format("constraintKeys: %s is not equal to %s", check, this.constraintKeys));
            }
        }

        public List<ConstraintKey> getConstraintKeys() {
            return this.constraintKeys;
        }

        public void setConstraintKeys(List<ConstraintKey> constraintKeys) {
            this.constraintKeys = constraintKeys;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssertConstraintKeyRule)) {
                return false;
            }
            AssertConstraintKeyRule other = (AssertConstraintKeyRule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<ConstraintKey> this$constraintKeys = this.getConstraintKeys();
            List<ConstraintKey> other$constraintKeys = other.getConstraintKeys();
            return !(this$constraintKeys == null ? other$constraintKeys != null : !((Object)this$constraintKeys).equals(other$constraintKeys));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AssertConstraintKeyRule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<ConstraintKey> $constraintKeys = this.getConstraintKeys();
            result = result * 59 + ($constraintKeys == null ? 43 : ((Object)$constraintKeys).hashCode());
            return result;
        }

        public String toString() {
            return "AssertCatalogTableRule.AssertConstraintKeyRule(constraintKeys=" + this.getConstraintKeys() + ")";
        }

        public AssertConstraintKeyRule(List<ConstraintKey> constraintKeys) {
            this.constraintKeys = constraintKeys;
        }
    }

    public static class AssertColumnRule
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<Column> columns;

        public void checkRule(List<Column> check) {
            if (CollectionUtils.isEmpty(check)) {
                throw new AssertConnectorException((SeaTunnelErrorCode)AssertConnectorErrorCode.CATALOG_TABLE_FAILED, "columns is null");
            }
            if (this.columns.size() != check.size()) {
                throw new AssertConnectorException((SeaTunnelErrorCode)AssertConnectorErrorCode.CATALOG_TABLE_FAILED, String.format("columns: %s is not equal to %s", check, this.columns));
            }
            for (int i = 0; i < this.columns.size(); ++i) {
                if (AssertCatalogTableRule.isColumnEqual(this.columns.get(i), check.get(i))) continue;
                throw new AssertConnectorException((SeaTunnelErrorCode)AssertConnectorErrorCode.CATALOG_TABLE_FAILED, String.format("columns: %s is not equal to %s", check.get(i), this.columns.get(i)));
            }
        }

        public List<Column> getColumns() {
            return this.columns;
        }

        public void setColumns(List<Column> columns) {
            this.columns = columns;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssertColumnRule)) {
                return false;
            }
            AssertColumnRule other = (AssertColumnRule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Column> this$columns = this.getColumns();
            List<Column> other$columns = other.getColumns();
            return !(this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AssertColumnRule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Column> $columns = this.getColumns();
            result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
            return result;
        }

        public String toString() {
            return "AssertCatalogTableRule.AssertColumnRule(columns=" + this.getColumns() + ")";
        }

        public AssertColumnRule(List<Column> columns) {
            this.columns = columns;
        }
    }

    public static class AssertTableIdentifierRule
    implements Serializable {
        private TableIdentifier tableIdentifier;

        public void checkRule(TableIdentifier actiualTableIdentifier) {
            if (actiualTableIdentifier == null) {
                throw new AssertConnectorException((SeaTunnelErrorCode)AssertConnectorErrorCode.CATALOG_TABLE_FAILED, "tableIdentifier is null");
            }
            if (!actiualTableIdentifier.equals((Object)this.tableIdentifier)) {
                throw new AssertConnectorException((SeaTunnelErrorCode)AssertConnectorErrorCode.CATALOG_TABLE_FAILED, String.format("tableIdentifier: %s is not equal to %s", actiualTableIdentifier, this.tableIdentifier));
            }
        }

        public TableIdentifier getTableIdentifier() {
            return this.tableIdentifier;
        }

        public void setTableIdentifier(TableIdentifier tableIdentifier) {
            this.tableIdentifier = tableIdentifier;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssertTableIdentifierRule)) {
                return false;
            }
            AssertTableIdentifierRule other = (AssertTableIdentifierRule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TableIdentifier this$tableIdentifier = this.getTableIdentifier();
            TableIdentifier other$tableIdentifier = other.getTableIdentifier();
            return !(this$tableIdentifier == null ? other$tableIdentifier != null : !this$tableIdentifier.equals(other$tableIdentifier));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AssertTableIdentifierRule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TableIdentifier $tableIdentifier = this.getTableIdentifier();
            result = result * 59 + ($tableIdentifier == null ? 43 : $tableIdentifier.hashCode());
            return result;
        }

        public String toString() {
            return "AssertCatalogTableRule.AssertTableIdentifierRule(tableIdentifier=" + this.getTableIdentifier() + ")";
        }

        public AssertTableIdentifierRule(TableIdentifier tableIdentifier) {
            this.tableIdentifier = tableIdentifier;
        }
    }
}

