/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.assertion.excecutor;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.connectors.seatunnel.assertion.rule.AssertFieldRule;
import org.apache.seatunnel.format.json.JsonToRowConverters;

public class AssertExecutor {
    public Optional<AssertFieldRule> fail(SeaTunnelRow rowData, SeaTunnelRowType rowType, List<AssertFieldRule> assertFieldRules) {
        return assertFieldRules.stream().filter(assertFieldRule -> !this.pass(rowData, rowType, (AssertFieldRule)assertFieldRule)).findFirst();
    }

    private boolean pass(SeaTunnelRow rowData, SeaTunnelRowType rowType, AssertFieldRule assertFieldRule) {
        if (Objects.isNull(rowData)) {
            return Boolean.FALSE;
        }
        int index = Iterables.indexOf((Iterable)Lists.newArrayList((Object[])rowType.getFieldNames()), fieldName -> fieldName.equals(assertFieldRule.getFieldName()));
        SeaTunnelDataType type = rowType.getFieldType(index);
        Object value = rowData.getField(index);
        Boolean typeChecked = this.checkType(value, assertFieldRule.getFieldType());
        if (Boolean.FALSE.equals(typeChecked)) {
            return Boolean.FALSE;
        }
        Boolean valueChecked = this.checkValue(value, type, assertFieldRule.getFieldRules());
        if (Boolean.FALSE.equals(valueChecked)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkValue(Object value, SeaTunnelDataType<?> type, List<AssertFieldRule.AssertRule> fieldValueRules) {
        Optional<AssertFieldRule.AssertRule> failValueRule = fieldValueRules.stream().filter(valueRule -> !this.pass(value, type, (AssertFieldRule.AssertRule)valueRule)).findFirst();
        if (failValueRule.isPresent()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean pass(Object value, SeaTunnelDataType<?> type, AssertFieldRule.AssertRule valueRule) {
        AssertFieldRule.AssertRuleType ruleType = valueRule.getRuleType();
        boolean isPass = true;
        if (ruleType != null) {
            isPass = this.checkAssertRule(value, type, valueRule);
        }
        if (Objects.nonNull(value) && valueRule.getEqualTo() != null) {
            isPass = isPass && this.compareValue(value, type, valueRule);
        }
        return isPass;
    }

    private boolean checkAssertRule(Object value, SeaTunnelDataType<?> type, AssertFieldRule.AssertRule valueRule) {
        switch (valueRule.getRuleType()) {
            case NULL: {
                return Objects.isNull(value);
            }
            case NOT_NULL: {
                return Objects.nonNull(value);
            }
            case MAX: {
                if (Objects.isNull(value) || !(value instanceof Number)) {
                    return Boolean.FALSE;
                }
                return ((Number)value).doubleValue() <= valueRule.getRuleValue();
            }
            case MIN: {
                if (Objects.isNull(value) || !(value instanceof Number)) {
                    return Boolean.FALSE;
                }
                return ((Number)value).doubleValue() >= valueRule.getRuleValue();
            }
            case MAX_LENGTH: {
                String valueStr = Objects.isNull(value) ? "" : String.valueOf(value);
                return (double)valueStr.length() <= valueRule.getRuleValue();
            }
            case MIN_LENGTH: {
                String valueStr = Objects.isNull(value) ? "" : String.valueOf(value);
                return (double)valueStr.length() >= valueRule.getRuleValue();
            }
        }
        return false;
    }

    private boolean compareValue(Object value, SeaTunnelDataType<?> type, AssertFieldRule.AssertRule valueRule) {
        Object confValue;
        Object config = valueRule.getEqualTo();
        String confJsonStr = JsonUtils.toJsonString((Object)config);
        JsonToRowConverters converters = new JsonToRowConverters(true, false);
        JsonToRowConverters.JsonToRowConverter converter = converters.createConverter(type);
        try {
            confValue = converter.convert(JsonUtils.stringToJsonNode((String)JsonUtils.toJsonString((Object)config)));
        }
        catch (IOException e) {
            throw CommonError.jsonOperationError((String)"Assert", (String)confJsonStr, (Throwable)e);
        }
        return this.compareValue(value, type, confValue);
    }

    private boolean compareValue(Object value, SeaTunnelDataType<?> type, Object confValue) {
        switch (type.getSqlType()) {
            case ROW: {
                return this.compareRowValue((SeaTunnelRow)value, (SeaTunnelRowType)type, (SeaTunnelRow)confValue);
            }
            case ARRAY: {
                return this.compareArrayValue((Object[])value, (ArrayType)type, (Object[])confValue);
            }
            case MAP: {
                return this.compareMapValue((Map)value, (MapType)type, (Map)confValue);
            }
            case NULL: {
                return value == null && confValue == null;
            }
            case BYTES: {
                return Arrays.equals((byte[])value, (byte[])confValue);
            }
        }
        return value.equals(confValue);
    }

    private boolean compareRowValue(SeaTunnelRow value, SeaTunnelRowType type, SeaTunnelRow confValue) {
        Object[] confValFields;
        Object[] valFields = value.getFields();
        if (valFields.length != (confValFields = confValue.getFields()).length) {
            return false;
        }
        for (int idx = 0; idx < confValFields.length; ++idx) {
            Object fieldVal = valFields[idx];
            Object confField = confValFields[idx];
            SeaTunnelDataType fieldType = type.getFieldType(idx);
            if (this.compareValue(fieldVal, fieldType, confField)) continue;
            return false;
        }
        return true;
    }

    private boolean compareArrayValue(Object[] value, ArrayType<?, ?> type, Object[] confValue) {
        if (value.length != confValue.length) {
            return false;
        }
        BasicType elementType = type.getElementType();
        for (int idx = 0; idx < confValue.length; ++idx) {
            Object elementVal = value[idx];
            Object confElement = confValue[idx];
            if (this.compareValue(elementVal, (SeaTunnelDataType<?>)elementType, confElement)) continue;
            return false;
        }
        return true;
    }

    private boolean compareMapValue(Map<?, ?> value, MapType<?, ?> type, Map<?, ?> confValue) {
        if (value.size() != confValue.size()) {
            return false;
        }
        if (value.isEmpty()) {
            return true;
        }
        SeaTunnelDataType valType = type.getValueType();
        for (Map.Entry<?, ?> entry : confValue.entrySet()) {
            Object confKey = entry.getKey();
            Object confVal = entry.getValue();
            if (!value.containsKey(confKey)) {
                return false;
            }
            Object val = value.get(confKey);
            if (this.compareValue(val, valType, confVal)) continue;
            return false;
        }
        return true;
    }

    private Boolean checkType(Object value, SeaTunnelDataType<?> fieldType) {
        if (value == null) {
            if (fieldType.getSqlType() == SqlType.NULL) {
                return true;
            }
            return false;
        }
        if (fieldType.getSqlType() == SqlType.ROW) {
            return this.checkRowType(value, (SeaTunnelRowType)fieldType);
        }
        if (fieldType.getSqlType() == SqlType.ARRAY) {
            return this.checkArrayType(value, (ArrayType)fieldType);
        }
        if (fieldType.getSqlType() == SqlType.MAP) {
            return this.checkMapType(value, (MapType)fieldType);
        }
        if (fieldType.getSqlType() == SqlType.DECIMAL) {
            return AssertExecutor.checkDecimalType(value, fieldType);
        }
        return value.getClass().equals(fieldType.getTypeClass());
    }

    private boolean checkArrayType(Object value, ArrayType<?, ?> fieldType) {
        if (!value.getClass().isArray()) {
            return false;
        }
        Object[] val = (Object[])value;
        BasicType elementType = fieldType.getElementType();
        for (Object elementObj : val) {
            if (this.checkType(elementObj, (SeaTunnelDataType<?>)elementType).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean checkMapType(Object value, MapType<?, ?> fieldType) {
        if (!(value instanceof Map)) {
            return false;
        }
        Map val = (Map)value;
        SeaTunnelDataType keyType = fieldType.getKeyType();
        SeaTunnelDataType valType = fieldType.getValueType();
        for (Map.Entry entry : val.entrySet()) {
            Object keyObj = entry.getKey();
            Object valObj = entry.getValue();
            if (this.checkType(keyObj, keyType).booleanValue() && this.checkType(valObj, valType).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean checkRowType(Object value, SeaTunnelRowType rowType) {
        if (!(value instanceof SeaTunnelRow)) {
            return false;
        }
        SeaTunnelRow row = (SeaTunnelRow)value;
        Object[] fields = row.getFields();
        for (int idx = 0; idx < fields.length; ++idx) {
            Object fieldVal = fields[idx];
            SeaTunnelDataType fieldType = rowType.getFieldType(idx);
            if (this.checkType(fieldVal, fieldType).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static Boolean checkDecimalType(Object value, SeaTunnelDataType<?> fieldType) {
        if (!value.getClass().equals(fieldType.getTypeClass())) {
            return false;
        }
        DecimalType fieldDecimalType = (DecimalType)fieldType;
        BigDecimal valueObj = (BigDecimal)value;
        if (valueObj.scale() != fieldDecimalType.getScale()) {
            return false;
        }
        return valueObj.precision() <= fieldDecimalType.getPrecision();
    }
}

