/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.assertion.sink;

import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.sink.SupportMultiTableSink;
import org.apache.seatunnel.api.table.catalog.CatalogOptions;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.assertion.rule.AssertCatalogTableRule;
import org.apache.seatunnel.connectors.seatunnel.assertion.rule.AssertFieldRule;
import org.apache.seatunnel.connectors.seatunnel.assertion.rule.AssertRuleParser;
import org.apache.seatunnel.connectors.seatunnel.assertion.rule.AssertTableRule;
import org.apache.seatunnel.connectors.seatunnel.assertion.sink.AssertConfig;
import org.apache.seatunnel.connectors.seatunnel.assertion.sink.AssertSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSimpleSink;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigException;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;

public class AssertSink
extends AbstractSimpleSink<SeaTunnelRow, Void>
implements SupportMultiTableSink {
    private SeaTunnelRowType seaTunnelRowType;
    private List<AssertFieldRule> assertFieldRules;
    private List<AssertFieldRule.AssertRule> assertRowRules;
    private final AssertTableRule assertTableRule;
    private AssertCatalogTableRule assertCatalogTableRule;

    public AssertSink(ReadonlyConfig pluginConfig, CatalogTable catalogTable) {
        this.seaTunnelRowType = catalogTable.getSeaTunnelRowType();
        if (!pluginConfig.getOptional(AssertConfig.RULES).isPresent()) {
            Throwables.propagateIfPossible((Throwable)new ConfigException.Missing(AssertConfig.RULES.key()));
        }
        Config ruleConfig = ConfigFactory.parseMap((Map)((Map)pluginConfig.get(AssertConfig.RULES)));
        List rowConfigList = null;
        List configList = null;
        if (ruleConfig.hasPath("row_rules")) {
            rowConfigList = ruleConfig.getConfigList("row_rules");
            this.assertRowRules = new AssertRuleParser().parseRowRules(rowConfigList);
        }
        if (ruleConfig.hasPath("field_rules")) {
            configList = ruleConfig.getConfigList("field_rules");
            this.assertFieldRules = new AssertRuleParser().parseRules(configList);
        }
        if (ruleConfig.hasPath("catalog_table_rule")) {
            this.assertCatalogTableRule = new AssertRuleParser().parseCatalogTableRule(ruleConfig.getConfig("catalog_table_rule"));
            this.assertCatalogTableRule.checkRule(catalogTable);
        }
        this.assertTableRule = ruleConfig.hasPath(CatalogOptions.TABLE_NAMES.key()) ? new AssertTableRule(ruleConfig.getStringList(CatalogOptions.TABLE_NAMES.key())) : new AssertTableRule(new ArrayList<String>());
        if (CollectionUtils.isEmpty((Collection)configList) && CollectionUtils.isEmpty((Collection)rowConfigList) && this.assertCatalogTableRule == null && this.assertTableRule.getTableNames().isEmpty()) {
            Throwables.propagateIfPossible((Throwable)new ConfigException.BadValue(AssertConfig.RULES.key(), "Assert rule config is empty, please add rule config."));
        }
    }

    @Override
    public AbstractSinkWriter<SeaTunnelRow, Void> createWriter(SinkWriter.Context context) {
        return new AssertSinkWriter(this.seaTunnelRowType, this.assertFieldRules, this.assertRowRules, this.assertTableRule);
    }

    public String getPluginName() {
        return "Assert";
    }
}

