/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.assertion.sink;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.LongAccumulator;
import org.apache.seatunnel.api.sink.SupportMultiTableSinkWriter;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.assertion.excecutor.AssertExecutor;
import org.apache.seatunnel.connectors.seatunnel.assertion.exception.AssertConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.assertion.exception.AssertConnectorException;
import org.apache.seatunnel.connectors.seatunnel.assertion.rule.AssertFieldRule;
import org.apache.seatunnel.connectors.seatunnel.assertion.rule.AssertTableRule;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;

public class AssertSinkWriter
extends AbstractSinkWriter<SeaTunnelRow, Void>
implements SupportMultiTableSinkWriter<Void> {
    private final SeaTunnelRowType seaTunnelRowType;
    private final List<AssertFieldRule> assertFieldRules;
    private final List<AssertFieldRule.AssertRule> assertRowRules;
    private final AssertTableRule assertTableRule;
    private static final AssertExecutor ASSERT_EXECUTOR = new AssertExecutor();
    private static final LongAccumulator LONG_ACCUMULATOR = new LongAccumulator(Long::sum, 0L);
    private static final Set<String> TABLE_NAMES = new CopyOnWriteArraySet<String>();

    public AssertSinkWriter(SeaTunnelRowType seaTunnelRowType, List<AssertFieldRule> assertFieldRules, List<AssertFieldRule.AssertRule> assertRowRules, AssertTableRule assertTableRule) {
        this.seaTunnelRowType = seaTunnelRowType;
        this.assertFieldRules = assertFieldRules;
        this.assertRowRules = assertRowRules;
        this.assertTableRule = assertTableRule;
    }

    public void write(SeaTunnelRow element) {
        LONG_ACCUMULATOR.accumulate(1L);
        TABLE_NAMES.add(element.getTableId());
        if (Objects.nonNull(this.assertFieldRules)) {
            ASSERT_EXECUTOR.fail(element, this.seaTunnelRowType, this.assertFieldRules).ifPresent(failRule -> {
                throw new AssertConnectorException((SeaTunnelErrorCode)AssertConnectorErrorCode.RULE_VALIDATION_FAILED, "row :" + element + " fail rule: " + failRule);
            });
        }
    }

    public void close() {
        if (Objects.nonNull(this.assertRowRules)) {
            this.assertRowRules.stream().filter(assertRule -> {
                switch (assertRule.getRuleType()) {
                    case MAX_ROW: {
                        return !((double)LONG_ACCUMULATOR.longValue() <= assertRule.getRuleValue());
                    }
                    case MIN_ROW: {
                        return !((double)LONG_ACCUMULATOR.longValue() >= assertRule.getRuleValue());
                    }
                }
                return false;
            }).findFirst().ifPresent(failRule -> {
                throw new AssertConnectorException((SeaTunnelErrorCode)AssertConnectorErrorCode.RULE_VALIDATION_FAILED, "row num :" + LONG_ACCUMULATOR.longValue() + " fail rule: " + failRule);
            });
        }
        if (!this.assertTableRule.getTableNames().isEmpty() && !new HashSet<String>(this.assertTableRule.getTableNames()).equals(TABLE_NAMES)) {
            throw new AssertConnectorException((SeaTunnelErrorCode)AssertConnectorErrorCode.RULE_VALIDATION_FAILED, "table names: " + TABLE_NAMES + " is not equal to " + this.assertTableRule.getTableNames());
        }
    }
}

