/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cassandra.config;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.cql.DefaultBatchType;
import java.io.Serializable;
import java.util.List;
import lombok.NonNull;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class CassandraConfig
implements Serializable {
    public static final String HOST = "host";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String DATACENTER = "datacenter";
    public static final String KEYSPACE = "keyspace";
    public static final String TABLE = "table";
    public static final String CQL = "cql";
    public static final String FIELDS = "fields";
    public static final String CONSISTENCY_LEVEL = "consistency_level";
    public static final String BATCH_SIZE = "batch_size";
    public static final String BATCH_TYPE = "batch_type";
    public static final String ASYNC_WRITE = "async_write";
    private String host;
    private String username;
    private String password;
    private String datacenter;
    private String keyspace;
    private String table;
    private String cql;
    private List<String> fields;
    private ConsistencyLevel consistencyLevel;
    private Integer batchSize;
    private DefaultBatchType batchType;
    private Boolean asyncWrite;

    public CassandraConfig(@NonNull String host, @NonNull String keyspace) {
        if (host == null) {
            throw new NullPointerException("host is marked @NonNull but is null");
        }
        if (keyspace == null) {
            throw new NullPointerException("keyspace is marked @NonNull but is null");
        }
        this.host = host;
        this.keyspace = keyspace;
    }

    public static CassandraConfig getCassandraConfig(Config config) {
        CassandraConfig cassandraConfig = new CassandraConfig(config.getString(HOST), config.getString(KEYSPACE));
        if (config.hasPath(USERNAME)) {
            cassandraConfig.setUsername(config.getString(USERNAME));
        }
        if (config.hasPath(PASSWORD)) {
            cassandraConfig.setPassword(config.getString(PASSWORD));
        }
        if (config.hasPath(DATACENTER)) {
            cassandraConfig.setDatacenter(config.getString(DATACENTER));
        } else {
            cassandraConfig.setDatacenter("datacenter1");
        }
        if (config.hasPath(TABLE)) {
            cassandraConfig.setTable(config.getString(TABLE));
        }
        if (config.hasPath(CQL)) {
            cassandraConfig.setCql(config.getString(CQL));
        }
        if (config.hasPath(FIELDS)) {
            cassandraConfig.setFields(config.getStringList(FIELDS));
        }
        if (config.hasPath(CONSISTENCY_LEVEL)) {
            cassandraConfig.setConsistencyLevel(DefaultConsistencyLevel.valueOf(config.getString(CONSISTENCY_LEVEL)));
        } else {
            cassandraConfig.setConsistencyLevel(DefaultConsistencyLevel.LOCAL_ONE);
        }
        if (config.hasPath(BATCH_SIZE)) {
            cassandraConfig.setBatchSize(config.getInt(BATCH_SIZE));
        } else {
            cassandraConfig.setBatchSize(Integer.parseInt("5000"));
        }
        if (config.hasPath(BATCH_TYPE)) {
            cassandraConfig.setBatchType(DefaultBatchType.valueOf(config.getString(BATCH_TYPE)));
        } else {
            cassandraConfig.setBatchType(DefaultBatchType.UNLOGGED);
        }
        if (config.hasPath(ASYNC_WRITE)) {
            cassandraConfig.setAsyncWrite(config.getBoolean(ASYNC_WRITE));
        } else {
            cassandraConfig.setAsyncWrite(true);
        }
        return cassandraConfig;
    }

    public String getHost() {
        return this.host;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public String getTable() {
        return this.table;
    }

    public String getCql() {
        return this.cql;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public DefaultBatchType getBatchType() {
        return this.batchType;
    }

    public Boolean getAsyncWrite() {
        return this.asyncWrite;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatacenter(String datacenter) {
        this.datacenter = datacenter;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setCql(String cql) {
        this.cql = cql;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setBatchType(DefaultBatchType batchType) {
        this.batchType = batchType;
    }

    public void setAsyncWrite(Boolean asyncWrite) {
        this.asyncWrite = asyncWrite;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CassandraConfig)) {
            return false;
        }
        CassandraConfig other = (CassandraConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$datacenter = this.getDatacenter();
        String other$datacenter = other.getDatacenter();
        if (this$datacenter == null ? other$datacenter != null : !this$datacenter.equals(other$datacenter)) {
            return false;
        }
        String this$keyspace = this.getKeyspace();
        String other$keyspace = other.getKeyspace();
        if (this$keyspace == null ? other$keyspace != null : !this$keyspace.equals(other$keyspace)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$cql = this.getCql();
        String other$cql = other.getCql();
        if (this$cql == null ? other$cql != null : !this$cql.equals(other$cql)) {
            return false;
        }
        List<String> this$fields = this.getFields();
        List<String> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        ConsistencyLevel this$consistencyLevel = this.getConsistencyLevel();
        ConsistencyLevel other$consistencyLevel = other.getConsistencyLevel();
        if (this$consistencyLevel == null ? other$consistencyLevel != null : !this$consistencyLevel.equals(other$consistencyLevel)) {
            return false;
        }
        Integer this$batchSize = this.getBatchSize();
        Integer other$batchSize = other.getBatchSize();
        if (this$batchSize == null ? other$batchSize != null : !((Object)this$batchSize).equals(other$batchSize)) {
            return false;
        }
        DefaultBatchType this$batchType = this.getBatchType();
        DefaultBatchType other$batchType = other.getBatchType();
        if (this$batchType == null ? other$batchType != null : !this$batchType.equals(other$batchType)) {
            return false;
        }
        Boolean this$asyncWrite = this.getAsyncWrite();
        Boolean other$asyncWrite = other.getAsyncWrite();
        return !(this$asyncWrite == null ? other$asyncWrite != null : !((Object)this$asyncWrite).equals(other$asyncWrite));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CassandraConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $datacenter = this.getDatacenter();
        result = result * 59 + ($datacenter == null ? 43 : $datacenter.hashCode());
        String $keyspace = this.getKeyspace();
        result = result * 59 + ($keyspace == null ? 43 : $keyspace.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $cql = this.getCql();
        result = result * 59 + ($cql == null ? 43 : $cql.hashCode());
        List<String> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        ConsistencyLevel $consistencyLevel = this.getConsistencyLevel();
        result = result * 59 + ($consistencyLevel == null ? 43 : $consistencyLevel.hashCode());
        Integer $batchSize = this.getBatchSize();
        result = result * 59 + ($batchSize == null ? 43 : ((Object)$batchSize).hashCode());
        DefaultBatchType $batchType = this.getBatchType();
        result = result * 59 + ($batchType == null ? 43 : $batchType.hashCode());
        Boolean $asyncWrite = this.getAsyncWrite();
        result = result * 59 + ($asyncWrite == null ? 43 : ((Object)$asyncWrite).hashCode());
        return result;
    }

    public String toString() {
        return "CassandraConfig(host=" + this.getHost() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", datacenter=" + this.getDatacenter() + ", keyspace=" + this.getKeyspace() + ", table=" + this.getTable() + ", cql=" + this.getCql() + ", fields=" + this.getFields() + ", consistencyLevel=" + this.getConsistencyLevel() + ", batchSize=" + this.getBatchSize() + ", batchType=" + this.getBatchType() + ", asyncWrite=" + this.getAsyncWrite() + ")";
    }

    public CassandraConfig() {
    }
}

