/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cassandra.sink;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.cassandra.client.CassandraClient;
import org.apache.seatunnel.connectors.seatunnel.cassandra.config.CassandraConfig;
import org.apache.seatunnel.connectors.seatunnel.cassandra.exception.CassandraConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.cassandra.exception.CassandraConnectorException;
import org.apache.seatunnel.connectors.seatunnel.cassandra.sink.CassandraSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSimpleSink;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={SeaTunnelSink.class})
public class CassandraSink
extends AbstractSimpleSink<SeaTunnelRow, Void> {
    private CassandraConfig cassandraConfig;
    private SeaTunnelRowType seaTunnelRowType;
    private ColumnDefinitions tableSchema;

    public String getPluginName() {
        return "Cassandra";
    }

    public void prepare(Config config) throws PrepareFailException {
        CheckResult checkResult = CheckConfigUtil.checkAllExists((Config)config, (String[])new String[]{"host", "keyspace", "table"});
        if (!checkResult.isSuccess()) {
            throw new CassandraConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", this.getPluginName(), PluginType.SINK, checkResult.getMsg()));
        }
        this.cassandraConfig = CassandraConfig.getCassandraConfig(config);
        try (CqlSession session = (CqlSession)CassandraClient.getCqlSessionBuilder(this.cassandraConfig.getHost(), this.cassandraConfig.getKeyspace(), this.cassandraConfig.getUsername(), this.cassandraConfig.getPassword(), this.cassandraConfig.getDatacenter()).build();){
            List<String> fields = this.cassandraConfig.getFields();
            this.tableSchema = CassandraClient.getTableSchema(session, this.cassandraConfig.getTable());
            if (fields == null || fields.isEmpty()) {
                ArrayList<String> newFields = new ArrayList<String>();
                for (int i = 0; i < this.tableSchema.size(); ++i) {
                    newFields.add(this.tableSchema.get(i).getName().asInternal());
                }
                this.cassandraConfig.setFields(newFields);
            } else {
                for (String field : fields) {
                    if (this.tableSchema.contains(field)) continue;
                    throw new CassandraConnectorException((SeaTunnelErrorCode)CassandraConnectorErrorCode.FIELD_NOT_IN_TABLE, "Field " + field + " does not exist in table " + config.getString("table"));
                }
            }
        }
        catch (Exception e) {
            throw new CassandraConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", this.getPluginName(), PluginType.SINK, checkResult.getMsg()));
        }
    }

    public void setTypeInfo(SeaTunnelRowType seaTunnelRowType) {
        this.seaTunnelRowType = seaTunnelRowType;
    }

    public SeaTunnelDataType<SeaTunnelRow> getConsumedType() {
        return this.seaTunnelRowType;
    }

    @Override
    public AbstractSinkWriter<SeaTunnelRow, Void> createWriter(SinkWriter.Context context) throws IOException {
        return new CassandraSinkWriter(this.cassandraConfig, this.seaTunnelRowType, this.tableSchema);
    }
}

