/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cassandra.config;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.cql.DefaultBatchType;
import java.io.Serializable;
import java.util.List;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.cassandra.config.CassandraBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.cassandra.config.CassandraSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.cassandra.config.CassandraSourceOptions;

public class CassandraParameters
implements Serializable {
    private String host;
    private String username;
    private String password;
    private String datacenter;
    private String keyspace;
    private String table;
    private String cql;
    private List<String> fields;
    private ConsistencyLevel consistencyLevel;
    private Integer batchSize;
    private DefaultBatchType batchType;
    private Boolean asyncWrite;

    public void buildWithConfig(ReadonlyConfig config) {
        this.host = (String)config.get(CassandraBaseOptions.HOST);
        this.keyspace = (String)config.get(CassandraBaseOptions.KEYSPACE);
        this.username = (String)config.get(CassandraBaseOptions.USERNAME);
        this.password = (String)config.get(CassandraBaseOptions.PASSWORD);
        this.datacenter = (String)config.get(CassandraBaseOptions.DATACENTER);
        this.table = (String)config.get(CassandraSinkOptions.TABLE);
        this.cql = (String)config.get(CassandraSourceOptions.CQL);
        this.fields = (List)config.get(CassandraSinkOptions.FIELDS);
        this.consistencyLevel = DefaultConsistencyLevel.valueOf((String)config.get(CassandraBaseOptions.CONSISTENCY_LEVEL));
        this.batchSize = (Integer)config.get(CassandraSinkOptions.BATCH_SIZE);
        this.batchType = DefaultBatchType.valueOf((String)config.get(CassandraSinkOptions.BATCH_TYPE));
        this.asyncWrite = (Boolean)config.get(CassandraSinkOptions.ASYNC_WRITE);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatacenter(String datacenter) {
        this.datacenter = datacenter;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setCql(String cql) {
        this.cql = cql;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setBatchType(DefaultBatchType batchType) {
        this.batchType = batchType;
    }

    public void setAsyncWrite(Boolean asyncWrite) {
        this.asyncWrite = asyncWrite;
    }

    public String getHost() {
        return this.host;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public String getTable() {
        return this.table;
    }

    public String getCql() {
        return this.cql;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public DefaultBatchType getBatchType() {
        return this.batchType;
    }

    public Boolean getAsyncWrite() {
        return this.asyncWrite;
    }
}

