/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cassandra.source;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.Row;
import java.util.Collections;
import java.util.List;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SupportColumnProjection;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.cassandra.client.CassandraClient;
import org.apache.seatunnel.connectors.seatunnel.cassandra.config.CassandraParameters;
import org.apache.seatunnel.connectors.seatunnel.cassandra.config.CassandraSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.cassandra.exception.CassandraConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.cassandra.exception.CassandraConnectorException;
import org.apache.seatunnel.connectors.seatunnel.cassandra.source.CassandraSourceReader;
import org.apache.seatunnel.connectors.seatunnel.cassandra.util.TypeConvertUtil;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitReader;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitSource;
import org.apache.seatunnel.connectors.seatunnel.common.source.SingleSplitReaderContext;

public class CassandraSource
extends AbstractSingleSplitSource<SeaTunnelRow>
implements SupportColumnProjection {
    private final CassandraParameters cassandraParameters;
    private final CatalogTable catalogTable;

    public CassandraSource(CassandraParameters cassandraParameters, ReadonlyConfig pluginConfig) {
        this.cassandraParameters = cassandraParameters;
        try (CqlSession currentSession = (CqlSession)CassandraClient.getCqlSessionBuilder(cassandraParameters.getHost(), cassandraParameters.getKeyspace(), cassandraParameters.getUsername(), cassandraParameters.getPassword(), cassandraParameters.getDatacenter()).build();){
            Row rs = (Row)currentSession.execute(CassandraClient.createSimpleStatement((String)pluginConfig.get(CassandraSourceOptions.CQL), cassandraParameters.getConsistencyLevel())).one();
            if (rs == null) {
                throw new CassandraConnectorException((SeaTunnelErrorCode)CassandraConnectorErrorCode.NO_DATA_IN_SOURCE_TABLE, "No data select from this cql: " + (String)pluginConfig.get(CassandraSourceOptions.CQL));
            }
            int columnSize = rs.getColumnDefinitions().size();
            TableSchema.Builder schemaBuilder = TableSchema.builder();
            String tableName = "default";
            for (int i = 0; i < columnSize; ++i) {
                PhysicalColumn physicalColumn = PhysicalColumn.of((String)rs.getColumnDefinitions().get(i).getName().asInternal(), TypeConvertUtil.convert(rs.getColumnDefinitions().get(i).getType()), null, null, (boolean)true, null, null);
                schemaBuilder.column((Column)physicalColumn);
                tableName = rs.getColumnDefinitions().get(i).getTable().asInternal();
            }
            this.catalogTable = CatalogTable.of((TableIdentifier)TableIdentifier.of((String)this.getPluginName(), (String)cassandraParameters.getKeyspace(), (String)tableName), (TableSchema)schemaBuilder.build(), Collections.emptyMap(), Collections.emptyList(), (String)"");
        }
        catch (Exception e) {
            throw new CassandraConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.TABLE_SCHEMA_GET_FAILED, "Get table schema from cassandra source data failed", e);
        }
    }

    public String getPluginName() {
        return "Cassandra";
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return Collections.singletonList(this.catalogTable);
    }

    @Override
    public AbstractSingleSplitReader<SeaTunnelRow> createReader(SingleSplitReaderContext readerContext) throws Exception {
        return new CassandraSourceReader(this.cassandraParameters, readerContext);
    }
}

