/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cassandra.client;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatementBuilder;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.cassandra.exception.CassandraConnectorException;

public class CassandraClient {
    public static CqlSessionBuilder getCqlSessionBuilder(String nodeAddress, String keyspace, String username, String password, String dataCenter) {
        List cqlSessionBuilderList = Arrays.stream(nodeAddress.split(",")).map(address -> {
            String[] nodeAndPort = address.split(":", 2);
            if (StringUtils.isEmpty(username) && StringUtils.isEmpty(password)) {
                return (CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().addContactPoint(new InetSocketAddress(nodeAndPort[0], Integer.parseInt(nodeAndPort[1])))).withKeyspace(keyspace)).withLocalDatacenter(dataCenter);
            }
            return (CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().addContactPoint(new InetSocketAddress(nodeAndPort[0], Integer.parseInt(nodeAndPort[1])))).withAuthCredentials(username, password)).withKeyspace(keyspace)).withLocalDatacenter(dataCenter);
        }).collect(Collectors.toList());
        return (CqlSessionBuilder)cqlSessionBuilderList.get(ThreadLocalRandom.current().nextInt(cqlSessionBuilderList.size()));
    }

    public static SimpleStatement createSimpleStatement(String cql, ConsistencyLevel consistencyLevel) {
        return ((SimpleStatementBuilder)SimpleStatement.builder(cql).setConsistencyLevel(consistencyLevel)).build();
    }

    public static ColumnDefinitions getTableSchema(CqlSession session, String table) {
        try {
            return session.execute(String.format("select * from %s limit 1", table)).getColumnDefinitions();
        }
        catch (Exception e) {
            throw new CassandraConnectorException((SeaTunnelErrorCode)CommonErrorCode.TABLE_SCHEMA_GET_FAILED, "Cannot get table schema from cassandra", e);
        }
    }
}

