/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.graph;

import com.datastax.dse.driver.api.core.graph.BatchGraphStatement;
import com.datastax.dse.driver.api.core.graph.GraphStatementBuilderBase;
import com.datastax.dse.driver.internal.core.graph.DefaultBatchGraphStatement;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.NotThreadSafe;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;

@NotThreadSafe
public class BatchGraphStatementBuilder
extends GraphStatementBuilderBase<BatchGraphStatementBuilder, BatchGraphStatement> {
    private ImmutableList.Builder<GraphTraversal> traversalsBuilder = ImmutableList.builder();
    private int traversalsCount;

    public BatchGraphStatementBuilder() {
    }

    public BatchGraphStatementBuilder(BatchGraphStatement template) {
        super(template);
        this.traversalsBuilder.addAll((Iterable)template);
        this.traversalsCount = template.size();
    }

    @NonNull
    public BatchGraphStatementBuilder addTraversal(@NonNull GraphTraversal traversal) {
        this.traversalsBuilder.add((Object)traversal);
        ++this.traversalsCount;
        return this;
    }

    @NonNull
    public BatchGraphStatementBuilder addTraversals(@NonNull Iterable<GraphTraversal> traversals) {
        for (GraphTraversal traversal : traversals) {
            this.traversalsBuilder.add((Object)traversal);
            ++this.traversalsCount;
        }
        return this;
    }

    @NonNull
    public BatchGraphStatementBuilder addTraversals(GraphTraversal ... traversals) {
        for (GraphTraversal traversal : traversals) {
            this.traversalsBuilder.add((Object)traversal);
            ++this.traversalsCount;
        }
        return this;
    }

    @NonNull
    public BatchGraphStatementBuilder clearTraversals() {
        this.traversalsBuilder = ImmutableList.builder();
        this.traversalsCount = 0;
        return this;
    }

    public int getTraversalsCount() {
        return this.traversalsCount;
    }

    @Override
    @NonNull
    public BatchGraphStatement build() {
        return new DefaultBatchGraphStatement(this.traversalsBuilder.build(), this.isIdempotent, this.timeout, this.node, this.timestamp, this.executionProfile, this.executionProfileName, this.buildCustomPayload(), this.graphName, this.traversalSource, this.subProtocol, this.consistencyLevel, this.readConsistencyLevel, this.writeConsistencyLevel);
    }
}

