/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.data.geometry.Geometry;
import com.datastax.dse.driver.api.core.data.geometry.LineString;
import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.api.core.data.geometry.Polygon;
import com.datastax.dse.driver.internal.core.graph.LegacyGraphNode;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.net.InetAddresses;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParseException;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.TreeNode;
import org.apache.tinkerpop.shaded.jackson.core.Version;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.JsonDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;

public class GraphSON1SerdeTP {

    static class GraphSON1JavaTimeModule
    extends SimpleModule {
        private static final long serialVersionUID = 1L;

        GraphSON1JavaTimeModule(String name, Version version) {
            super(name, version, GraphSON1JavaTimeModule.createDeserializers(), GraphSON1JavaTimeModule.createSerializers());
        }

        private static Map<Class<?>, JsonDeserializer<?>> createDeserializers() {
            return ImmutableMap.builder().put(Duration.class, new DurationJacksonDeserializer()).put(Instant.class, (DurationJacksonDeserializer)((Object)new InstantJacksonDeserializer())).put(LocalDate.class, (DurationJacksonDeserializer)((Object)new LocalDateJacksonDeserializer())).put(LocalTime.class, (DurationJacksonDeserializer)((Object)new LocalTimeJacksonDeserializer())).build();
        }

        private static List<JsonSerializer<?>> createSerializers() {
            return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add((Object)new DurationJacksonSerializer())).add((Object)new InstantJacksonSerializer())).add((Object)new LocalDateJacksonSerializer())).add((Object)new LocalTimeJacksonSerializer())).build();
        }
    }

    static class GraphSON1DefaultModule
    extends SimpleModule {
        private static final long serialVersionUID = 1L;

        GraphSON1DefaultModule(String name, Version version) {
            super(name, version, GraphSON1DefaultModule.createDeserializers(), GraphSON1DefaultModule.createSerializers());
        }

        private static Map<Class<?>, JsonDeserializer<?>> createDeserializers() {
            return ImmutableMap.builder().put(InetAddress.class, new DefaultInetAddressDeserializer<InetAddress>(InetAddress.class)).put(Inet4Address.class, new DefaultInetAddressDeserializer<Inet4Address>(Inet4Address.class)).put(Inet6Address.class, new DefaultInetAddressDeserializer<Inet6Address>(Inet6Address.class)).put((Class<Inet6Address>)Geometry.class, (DefaultInetAddressDeserializer<Inet6Address>)((Object)new DefaultGeometryDeserializer<Geometry>(Geometry.class))).put(Point.class, new DefaultGeometryDeserializer<Point>(Point.class)).put(LineString.class, new DefaultGeometryDeserializer<LineString>(LineString.class)).put(Polygon.class, new DefaultGeometryDeserializer<Polygon>(Polygon.class)).build();
        }

        private static List<JsonSerializer<?>> createSerializers() {
            return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add((Object)new DefaultGraphNodeSerializer())).add((Object)new DefaultGeometrySerializer())).build();
        }
    }

    static class DefaultGeometrySerializer
    extends StdSerializer<Geometry> {
        private static final long serialVersionUID = 1L;

        DefaultGeometrySerializer() {
            super(Geometry.class);
        }

        public void serialize(Geometry value, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException {
            jsonGenerator.writeString(value.asWellKnownText());
        }
    }

    static class DefaultGraphNodeSerializer
    extends StdSerializer<LegacyGraphNode> {
        private static final long serialVersionUID = 1L;

        DefaultGraphNodeSerializer() {
            super(LegacyGraphNode.class);
        }

        public void serialize(LegacyGraphNode value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeTree((TreeNode)value.getDelegate());
        }
    }

    static final class LocalTimeJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<LocalTime> {
        private static final long serialVersionUID = 1L;

        LocalTimeJacksonDeserializer() {
            super(LocalTime.class);
        }

        @Override
        public LocalTime parse(String val) {
            return LocalTime.parse(val);
        }
    }

    static final class LocalTimeJacksonSerializer
    extends AbstractJavaTimeSerializer<LocalTime> {
        private static final long serialVersionUID = 1L;

        LocalTimeJacksonSerializer() {
            super(LocalTime.class);
        }
    }

    static final class LocalDateJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<LocalDate> {
        private static final long serialVersionUID = 1L;

        LocalDateJacksonDeserializer() {
            super(LocalDate.class);
        }

        @Override
        public LocalDate parse(String val) {
            return LocalDate.parse(val);
        }
    }

    static final class LocalDateJacksonSerializer
    extends AbstractJavaTimeSerializer<LocalDate> {
        private static final long serialVersionUID = 1L;

        LocalDateJacksonSerializer() {
            super(LocalDate.class);
        }
    }

    static final class InstantJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<Instant> {
        private static final long serialVersionUID = 1L;

        InstantJacksonDeserializer() {
            super(Instant.class);
        }

        @Override
        public Instant parse(String val) {
            return Instant.parse(val);
        }
    }

    static final class InstantJacksonSerializer
    extends AbstractJavaTimeSerializer<Instant> {
        private static final long serialVersionUID = 1L;

        InstantJacksonSerializer() {
            super(Instant.class);
        }
    }

    static final class DurationJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<Duration> {
        private static final long serialVersionUID = 1L;

        DurationJacksonDeserializer() {
            super(Duration.class);
        }

        @Override
        public Duration parse(String val) {
            return Duration.parse(val);
        }
    }

    static final class DurationJacksonSerializer
    extends AbstractJavaTimeSerializer<Duration> {
        private static final long serialVersionUID = 1L;

        DurationJacksonSerializer() {
            super(Duration.class);
        }
    }

    static abstract class AbstractJavaTimeJacksonDeserializer<T>
    extends StdDeserializer<T> {
        private static final long serialVersionUID = 1L;

        AbstractJavaTimeJacksonDeserializer(Class<T> clazz) {
            super(clazz);
        }

        abstract T parse(String var1);

        public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return this.parse(jsonParser.getText());
        }
    }

    static abstract class AbstractJavaTimeSerializer<T>
    extends StdSerializer<T> {
        private static final long serialVersionUID = 1L;

        AbstractJavaTimeSerializer(Class<T> clazz) {
            super(clazz);
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
            gen.writeString(value.toString());
        }
    }

    static class DefaultGeometryDeserializer<T extends Geometry>
    extends StdDeserializer<T> {
        private static final long serialVersionUID = 1L;
        private final Class<T> geometryClass;

        DefaultGeometryDeserializer(Class<T> geometryClass) {
            super(geometryClass);
            this.geometryClass = geometryClass;
        }

        public T deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
            Geometry geometry;
            String wkt = (String)parser.readValueAs(String.class);
            if (wkt.startsWith("POINT")) {
                geometry = Point.fromWellKnownText(wkt);
            } else if (wkt.startsWith("LINESTRING")) {
                geometry = LineString.fromWellKnownText(wkt);
            } else if (wkt.startsWith("POLYGON")) {
                geometry = Polygon.fromWellKnownText(wkt);
            } else {
                throw new JsonParseException(parser, "Unknown geometry type: " + wkt);
            }
            return (T)((Geometry)this.geometryClass.cast(geometry));
        }
    }

    static class DefaultInetAddressDeserializer<T extends InetAddress>
    extends StdDeserializer<T> {
        private static final long serialVersionUID = 1L;
        private final Class<T> inetClass;

        DefaultInetAddressDeserializer(Class<T> inetClass) {
            super(inetClass);
            this.inetClass = inetClass;
        }

        public T deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
            String ip = (String)parser.readValueAs(String.class);
            try {
                InetAddress inet = InetAddresses.forString(ip);
                return (T)((InetAddress)this.inetClass.cast(inet));
            }
            catch (ClassCastException e) {
                throw new JsonParseException(parser, String.format("Inet address cannot be cast to %s: %s", this.inetClass.getSimpleName(), ip), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException(parser, String.format("Expected inet address, got %s", ip), (Throwable)e);
            }
        }
    }
}

