/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cassandra.sink;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.connectors.seatunnel.cassandra.client.CassandraClient;
import org.apache.seatunnel.connectors.seatunnel.cassandra.config.CassandraConfig;
import org.apache.seatunnel.connectors.seatunnel.cassandra.config.CassandraParameters;
import org.apache.seatunnel.connectors.seatunnel.cassandra.exception.CassandraConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.cassandra.exception.CassandraConnectorException;
import org.apache.seatunnel.connectors.seatunnel.cassandra.sink.CassandraSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSimpleSink;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={SeaTunnelSink.class})
public class CassandraSink
extends AbstractSimpleSink<SeaTunnelRow, Void> {
    private final CassandraParameters cassandraParameters = new CassandraParameters();
    private SeaTunnelRowType seaTunnelRowType;
    private ColumnDefinitions tableSchema;

    public String getPluginName() {
        return "Cassandra";
    }

    public void prepare(Config pluginConfig) throws PrepareFailException {
        CheckResult checkResult = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{CassandraConfig.HOST.key(), CassandraConfig.KEYSPACE.key(), CassandraConfig.TABLE.key()});
        if (!checkResult.isSuccess()) {
            throw new CassandraConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", this.getPluginName(), PluginType.SINK, checkResult.getMsg()));
        }
        this.cassandraParameters.buildWithConfig(pluginConfig);
        try (CqlSession session = (CqlSession)CassandraClient.getCqlSessionBuilder(this.cassandraParameters.getHost(), this.cassandraParameters.getKeyspace(), this.cassandraParameters.getUsername(), this.cassandraParameters.getPassword(), this.cassandraParameters.getDatacenter()).build();){
            List<String> fields = this.cassandraParameters.getFields();
            this.tableSchema = CassandraClient.getTableSchema(session, pluginConfig.getString(CassandraConfig.TABLE.key()));
            if (fields == null || fields.isEmpty()) {
                ArrayList<String> newFields = new ArrayList<String>();
                for (int i = 0; i < this.tableSchema.size(); ++i) {
                    newFields.add(this.tableSchema.get(i).getName().asInternal());
                }
                this.cassandraParameters.setFields(newFields);
            } else {
                for (String field : fields) {
                    if (this.tableSchema.contains(field)) continue;
                    throw new CassandraConnectorException((SeaTunnelErrorCode)CassandraConnectorErrorCode.FIELD_NOT_IN_TABLE, "Field " + field + " does not exist in table " + pluginConfig.getString(CassandraConfig.TABLE.key()));
                }
            }
        }
        catch (Exception e) {
            throw new CassandraConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", this.getPluginName(), PluginType.SINK, ExceptionUtils.getMessage((Throwable)e)));
        }
    }

    public void setTypeInfo(SeaTunnelRowType seaTunnelRowType) {
        this.seaTunnelRowType = seaTunnelRowType;
    }

    @Override
    public AbstractSinkWriter<SeaTunnelRow, Void> createWriter(SinkWriter.Context context) throws IOException {
        return new CassandraSinkWriter(this.cassandraParameters, this.seaTunnelRowType, this.tableSchema);
    }
}

