/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util;

import com.mongodb.MongoClientSettings;
import com.mongodb.ServerApi;
import com.mongodb.ServerApiVersion;
import com.mongodb.client.MongoClient;
import com.mongodb.kafka.connect.util.ConfigHelper;
import com.mongodb.kafka.connect.util.MongoClientHelper;
import com.mongodb.kafka.connect.util.Validators;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;

public final class ServerApiConfig {
    private static final String EMPTY_STRING = "";
    public static final String SERVER_API_VERSION_CONFIG = "server.api.version";
    private static final String SERVER_API_VERSION_DEFAULT = "";
    private static final String SERVER_API_VERSION_DISPLAY = "The server API version.";
    private static final String SERVER_API_VERSION_DOC = "The server API version to use. Disabled by default.";
    public static final String SERVER_API_DEPRECATION_ERRORS_CONFIG = "server.api.deprecation.errors";
    private static final boolean SERVER_API_DEPRECATION_ERRORS_DEFAULT = false;
    private static final String SERVER_API_DEPRECATION_ERRORS_DISPLAY = "Deprecation errors";
    private static final String SERVER_API_DEPRECATION_ERRORS_DOC = "Sets whether the connector requires use of deprecated server APIs to be reported as errors.";
    public static final String SERVER_API_STRICT_CONFIG = "server.api.strict";
    private static final boolean SERVER_API_STRICT_DEFAULT = false;
    private static final String SERVER_API_STRICT_DISPLAY = "Strict";
    private static final String SERVER_API_STRICT_DOC = "Sets whether the application requires strict server API version enforcement.";

    public static ConfigDef addServerApiConfig(ConfigDef configDef) {
        String group = "Server Api";
        int orderInGroup = 0;
        configDef.define(SERVER_API_VERSION_CONFIG, ConfigDef.Type.STRING, (Object)"", Validators.emptyString().or(Validators.errorCheckingValueValidator("A valid server version", ServerApiVersion::findByValue)), ConfigDef.Importance.MEDIUM, SERVER_API_VERSION_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, SERVER_API_VERSION_DISPLAY);
        configDef.define(SERVER_API_DEPRECATION_ERRORS_CONFIG, ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.MEDIUM, SERVER_API_DEPRECATION_ERRORS_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, SERVER_API_DEPRECATION_ERRORS_DISPLAY);
        configDef.define(SERVER_API_STRICT_CONFIG, ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.MEDIUM, SERVER_API_STRICT_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, SERVER_API_STRICT_DISPLAY);
        return configDef;
    }

    public static void validateServerApi(MongoClient mongoClient, Config config) {
        ConfigHelper.getConfigByName(config, SERVER_API_VERSION_CONFIG).ifPresent(serverApiVersion -> {
            if (!"".equals(serverApiVersion.value()) && !MongoClientHelper.isAtleastFiveDotZero(mongoClient)) {
                ConfigHelper.getConfigByName(config, "connection.uri").ifPresent(c -> c.addErrorMessage("Server Version API requires MongoDB 5.0 or greater"));
            }
        });
    }

    public static MongoClientSettings.Builder setServerApi(MongoClientSettings.Builder mongoClientSettingsBuilder, Config config) {
        ConfigHelper.getConfigByNameWithoutErrors(config, SERVER_API_VERSION_CONFIG).filter(s2 -> s2.errorMessages().isEmpty()).ifPresent(serverApiVersionObject -> {
            String serverApiVersion = (String)serverApiVersionObject.value();
            boolean deprecationErrors = ConfigHelper.getConfigByNameWithoutErrors(config, SERVER_API_DEPRECATION_ERRORS_CONFIG).map(c -> (Boolean)c.value()).orElse(false);
            boolean strict = ConfigHelper.getConfigByNameWithoutErrors(config, SERVER_API_STRICT_CONFIG).map(c -> (Boolean)c.value()).orElse(false);
            ServerApiConfig.setServerApi(mongoClientSettingsBuilder, serverApiVersion, deprecationErrors, strict);
        });
        return mongoClientSettingsBuilder;
    }

    public static MongoClientSettings.Builder setServerApi(MongoClientSettings.Builder mongoClientSettingsBuilder, AbstractConfig config) {
        return ServerApiConfig.setServerApi(mongoClientSettingsBuilder, config.getString(SERVER_API_VERSION_CONFIG), config.getBoolean(SERVER_API_DEPRECATION_ERRORS_CONFIG), config.getBoolean(SERVER_API_STRICT_CONFIG));
    }

    private static MongoClientSettings.Builder setServerApi(MongoClientSettings.Builder mongoClientSettingsBuilder, String serverApiVersion, boolean deprecationErrors, boolean strict) {
        if (!serverApiVersion.isEmpty()) {
            ServerApi.Builder serverApiBuilder = ServerApi.builder();
            serverApiBuilder.version(ServerApiVersion.findByValue(serverApiVersion));
            serverApiBuilder.deprecationErrors(deprecationErrors);
            serverApiBuilder.strict(strict);
            mongoClientSettingsBuilder.serverApi(serverApiBuilder.build());
        }
        return mongoClientSettingsBuilder;
    }

    private ServerApiConfig() {
    }
}

