/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.internal;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.config.MongodbSourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MongodbClientProvider {
    INSTANCE;

    private static final Logger log;
    private volatile MongoClient mongoClient;

    public MongoClient getOrCreateMongoClient(MongodbSourceConfig sourceConfig) {
        if (this.mongoClient == null) {
            ConnectionString connectionString = new ConnectionString(sourceConfig.getConnectionString());
            log.info("Create and register mongo client {}@{}", (Object)connectionString.getUsername(), connectionString.getHosts());
            this.mongoClient = MongoClients.create(connectionString);
        }
        return this.mongoClient;
    }

    static {
        log = LoggerFactory.getLogger(MongodbClientProvider.class);
    }
}

