/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.writemodel.strategy;

import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.writemodel.strategy.WriteModelStrategy;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public class ReplaceOneDefaultStrategy
implements WriteModelStrategy {
    private static final ReplaceOptions REPLACE_OPTIONS = new ReplaceOptions().upsert(true);

    @Override
    public WriteModel<BsonDocument> createWriteModel(SinkDocument document) {
        BsonDocument vd = document.getValueDoc().orElseThrow(() -> new DataException("Could not build the WriteModel,the value document was missing unexpectedly"));
        BsonValue idValue = vd.get("_id");
        if (idValue == null) {
            throw new DataException("Could not build the WriteModel,the `_id` field was missing unexpectedly");
        }
        return new ReplaceOneModel<BsonDocument>(new BsonDocument("_id", idValue), vd, REPLACE_OPTIONS);
    }
}

