/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.source.producer;

import com.mongodb.kafka.connect.source.MongoSourceConfig;
import com.mongodb.kafka.connect.source.producer.AvroSchemaAndValueProducer;
import com.mongodb.kafka.connect.source.producer.BsonSchemaAndValueProducer;
import com.mongodb.kafka.connect.source.producer.InferSchemaAndValueProducer;
import com.mongodb.kafka.connect.source.producer.RawJsonStringSchemaAndValueProducer;
import com.mongodb.kafka.connect.source.producer.SchemaAndValueProducer;
import org.apache.kafka.connect.errors.ConnectException;

public final class SchemaAndValueProducers {
    public static SchemaAndValueProducer createKeySchemaAndValueProvider(MongoSourceConfig config) {
        return SchemaAndValueProducers.createSchemaAndValueProvider(config, false);
    }

    public static SchemaAndValueProducer createValueSchemaAndValueProvider(MongoSourceConfig config) {
        return SchemaAndValueProducers.createSchemaAndValueProvider(config, true);
    }

    private static SchemaAndValueProducer createSchemaAndValueProvider(MongoSourceConfig config, boolean isValue) {
        MongoSourceConfig.OutputFormat outputFormat = isValue ? config.getValueOutputFormat() : config.getKeyOutputFormat();
        switch (outputFormat) {
            case JSON: {
                return new RawJsonStringSchemaAndValueProducer(config.getJsonWriterSettings());
            }
            case BSON: {
                return new BsonSchemaAndValueProducer();
            }
            case SCHEMA: {
                String jsonSchema;
                String string = jsonSchema = isValue ? config.getString("output.schema.value") : config.getString("output.schema.key");
                if (isValue && config.getBoolean("output.schema.infer.value").booleanValue()) {
                    return new InferSchemaAndValueProducer(config.getJsonWriterSettings());
                }
                return new AvroSchemaAndValueProducer(jsonSchema, config.getJsonWriterSettings());
            }
        }
        throw new ConnectException("Unsupported key output format" + (Object)((Object)config.getKeyOutputFormat()));
    }

    private SchemaAndValueProducers() {
    }
}

