/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.mongodb.MongoUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@ThreadSafe
public class MongoClients {
    private final Map<ServerAddress, MongoClient> directConnections = new ConcurrentHashMap<ServerAddress, MongoClient>();
    private final Map<List<ServerAddress>, MongoClient> connections = new ConcurrentHashMap<List<ServerAddress>, MongoClient>();
    private final MongoClientSettings.Builder settings;

    public static Builder create() {
        return new Builder();
    }

    private MongoClients(MongoClientSettings.Builder settings) {
        this.settings = settings;
    }

    public void clear() {
        this.directConnections.values().forEach(MongoClient::close);
        this.connections.values().forEach(MongoClient::close);
        this.directConnections.clear();
        this.connections.clear();
    }

    public MongoClient clientFor(String addressString) {
        return this.clientFor(MongoUtil.parseAddress(addressString));
    }

    public MongoClient clientFor(ServerAddress address) {
        return this.directConnections.computeIfAbsent(address, this::directConnection);
    }

    public MongoClient clientForMembers(String addressList) {
        return this.clientForMembers(MongoUtil.parseAddresses(addressList));
    }

    public MongoClient clientForMembers(ServerAddress ... seeds) {
        ArrayList<ServerAddress> addresses = new ArrayList<ServerAddress>();
        for (ServerAddress seedAddress : seeds) {
            if (seedAddress == null) continue;
            addresses.add(seedAddress);
        }
        return this.clientForMembers(addresses);
    }

    public MongoClient clientForMembers(List<ServerAddress> seedAddresses) {
        return this.connections.computeIfAbsent(seedAddresses, this::connection);
    }

    protected MongoClient directConnection(ServerAddress address) {
        this.settings.applyToClusterSettings(builder -> builder.hosts(Collections.singletonList(address)));
        return com.mongodb.client.MongoClients.create(this.settings.build());
    }

    protected MongoClient connection(List<ServerAddress> addresses) {
        this.settings.applyToClusterSettings(builder -> builder.hosts(addresses));
        return com.mongodb.client.MongoClients.create(this.settings.build());
    }

    public static class Builder {
        private final MongoClientSettings.Builder settingsBuilder = MongoClientSettings.builder();

        public Builder withCredential(MongoCredential credential) {
            if (credential != null) {
                this.settingsBuilder.credential(credential);
            }
            return this;
        }

        public MongoClientSettings.Builder settings() {
            return this.settingsBuilder;
        }

        public MongoClients build() {
            return new MongoClients(this.settingsBuilder);
        }
    }
}

