/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.OperationType;
import io.debezium.annotation.Immutable;
import io.debezium.connector.mongodb.MongoDbCollectionSchema;
import io.debezium.connector.mongodb.MongoDbPartition;
import io.debezium.data.Envelope;
import io.debezium.pipeline.AbstractChangeRecordEmitter;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.util.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Struct;
import org.bson.Document;

public class MongoDbChangeStreamChangeRecordEmitter
extends AbstractChangeRecordEmitter<MongoDbPartition, MongoDbCollectionSchema> {
    private final ChangeStreamDocument<Document> changeStreamEvent;
    @Immutable
    private static final Map<OperationType, Envelope.Operation> OPERATION_LITERALS;

    public MongoDbChangeStreamChangeRecordEmitter(MongoDbPartition partition, OffsetContext offsetContext, Clock clock, ChangeStreamDocument<Document> changeStreamEvent) {
        super(partition, offsetContext, clock);
        this.changeStreamEvent = changeStreamEvent;
    }

    @Override
    public Envelope.Operation getOperation() {
        return OPERATION_LITERALS.get((Object)this.changeStreamEvent.getOperationType());
    }

    @Override
    protected void emitReadRecord(ChangeRecordEmitter.Receiver<MongoDbPartition> receiver, MongoDbCollectionSchema schema) throws InterruptedException {
    }

    @Override
    protected void emitCreateRecord(ChangeRecordEmitter.Receiver<MongoDbPartition> receiver, MongoDbCollectionSchema schema) throws InterruptedException {
        this.createAndEmitChangeRecord(receiver, schema);
    }

    @Override
    protected void emitUpdateRecord(ChangeRecordEmitter.Receiver<MongoDbPartition> receiver, MongoDbCollectionSchema schema) throws InterruptedException {
        this.createAndEmitChangeRecord(receiver, schema);
    }

    @Override
    protected void emitDeleteRecord(ChangeRecordEmitter.Receiver<MongoDbPartition> receiver, MongoDbCollectionSchema schema) throws InterruptedException {
        this.createAndEmitChangeRecord(receiver, schema);
    }

    private void createAndEmitChangeRecord(ChangeRecordEmitter.Receiver<MongoDbPartition> receiver, MongoDbCollectionSchema schema) throws InterruptedException {
        Struct newKey = schema.keyFromDocument(this.changeStreamEvent.getDocumentKey());
        assert (newKey != null);
        Struct value = schema.valueFromDocumentChangeStream(this.changeStreamEvent, this.getOperation());
        value.put("source", (Object)this.getOffset().getSourceInfo());
        value.put("op", (Object)this.getOperation().code());
        value.put("ts_ms", (Object)this.getClock().currentTimeAsInstant().toEpochMilli());
        receiver.changeRecord((MongoDbPartition)this.getPartition(), schema, this.getOperation(), newKey, value, this.getOffset(), null);
    }

    public static boolean isValidOperation(String operation) {
        return OPERATION_LITERALS.containsKey(operation);
    }

    static {
        HashMap<OperationType, Envelope.Operation> literals = new HashMap<OperationType, Envelope.Operation>();
        literals.put(OperationType.INSERT, Envelope.Operation.CREATE);
        literals.put(OperationType.UPDATE, Envelope.Operation.UPDATE);
        literals.put(OperationType.REPLACE, Envelope.Operation.UPDATE);
        literals.put(OperationType.DELETE, Envelope.Operation.DELETE);
        OPERATION_LITERALS = Collections.unmodifiableMap(literals);
    }
}

