/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util.jmx.internal;

import com.mongodb.lang.Nullable;
import java.lang.management.ManagementFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MBeanServerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MBeanServerUtils.class);
    public static final AtomicInteger NEXT_ID = new AtomicInteger();

    private MBeanServerUtils() {
    }

    @Nullable
    public static String registerMBean(DynamicMBean mBean, String mBeanName) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            String mBeanNameToTry = mBeanName;
            while (true) {
                try {
                    server.registerMBean(mBean, new ObjectName(mBeanNameToTry));
                    return mBeanNameToTry;
                }
                catch (InstanceAlreadyExistsException e) {
                    LOGGER.warn("MBean name conflict {}", (Object)mBeanNameToTry, (Object)e);
                    mBeanNameToTry = mBeanName + "-v" + NEXT_ID.getAndAdd(1);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to register MBean {}", (Object)mBeanName, (Object)e);
            return mBeanName + "-not-registered";
        }
    }

    public static void unregisterMBean(String mBeanName) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName(mBeanName);
            if (server.isRegistered(objectName)) {
                server.unregisterMBean(objectName);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to unregister MBean {}", (Object)mBeanName, (Object)e);
        }
    }

    public static String getMBeanDescriptionFor(String mBeanNameQuery, String attr) {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            Set<ObjectName> results = mBeanServer.queryNames(new ObjectName(mBeanNameQuery), null);
            for (ObjectName mBeanName : results) {
                for (MBeanAttributeInfo attributeInfo : mBeanServer.getMBeanInfo(mBeanName).getAttributes()) {
                    if (!attributeInfo.getName().equals(attr)) continue;
                    return attributeInfo.getDescription();
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Map<String, Long>> getMBeanAttributes(String mBeanNameQuery) {
        return MBeanServerUtils.getMBeanAttributes(ManagementFactory.getPlatformMBeanServer(), mBeanNameQuery);
    }

    public static Map<String, Map<String, Long>> getMBeanAttributes(MBeanServer mBeanServer, String mBeanNameQuery) {
        try {
            LinkedHashMap<String, Map<String, Long>> mbeansMap = new LinkedHashMap<String, Map<String, Long>>();
            Set<ObjectName> results = mBeanServer.queryNames(new ObjectName(mBeanNameQuery), null);
            for (ObjectName mBeanName : results) {
                MBeanInfo info = mBeanServer.getMBeanInfo(mBeanName);
                MBeanAttributeInfo[] attributeInfos = info.getAttributes();
                LinkedHashMap<String, Long> attributes = new LinkedHashMap<String, Long>();
                for (MBeanAttributeInfo attributeInfo : attributeInfos) {
                    Object value = mBeanServer.getAttribute(mBeanName, attributeInfo.getName());
                    if (value instanceof Long) {
                        attributes.put(attributeInfo.getName(), (Long)value);
                        continue;
                    }
                    if (!(value instanceof Attribute) || !(((Attribute)value).getValue() instanceof Long)) continue;
                    attributes.put(attributeInfo.getName(), (Long)((Attribute)value).getValue());
                }
                mbeansMap.put(mBeanName.toString(), attributes);
            }
            return mbeansMap;
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | IntrospectionException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    public static String taskIdFromCurrentThread() {
        String s2 = Thread.currentThread().getName();
        Matcher m3 = Pattern.compile("(\\d)+").matcher(s2);
        return m3.find() ? m3.group() : "unknown";
    }
}

