/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters;

import io.debezium.util.Collect;
import java.util.Set;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.transforms.util.Requirements;

public abstract class RecordParser {
    private final Struct record;
    private final Struct source;
    private final Struct transaction;
    private final String op;
    private final Schema opSchema;
    private final String ts_ms;
    private final Schema ts_msSchema;
    private final Schema dataSchema;
    private final String connectorType;
    static final Set<String> SOURCE_FIELDS = Collect.unmodifiableSet("version", "connector", "name", "ts_ms", "snapshot", "db");

    public static RecordParser create(Schema schema, Object value) {
        String connectorType;
        Struct record = Requirements.requireStruct(value, "CloudEvents converter");
        switch (connectorType = record.getStruct("source").getString("connector")) {
            case "mysql": {
                return new MysqlRecordParser(schema, record);
            }
            case "postgresql": {
                return new PostgresRecordParser(schema, record);
            }
            case "mongodb": {
                return new MongodbRecordParser(schema, record);
            }
            case "sqlserver": {
                return new SqlserverRecordParser(schema, record);
            }
        }
        throw new DataException("No usable CloudEvents converters for connector type \"" + connectorType + "\"");
    }

    protected RecordParser(Schema schema, Struct record, String ... dataFields) {
        this.record = record;
        this.source = record.getStruct("source");
        this.transaction = record.schema().field("transaction") != null ? record.getStruct("transaction") : null;
        this.op = record.getString("op");
        this.opSchema = schema.field("op").schema();
        this.ts_ms = record.getInt64("ts_ms").toString();
        this.ts_msSchema = schema.field("ts_ms").schema();
        this.connectorType = this.source.getString("connector");
        this.dataSchema = RecordParser.getDataSchema(schema, this.connectorType, dataFields);
    }

    private static Schema getDataSchema(Schema schema, String connectorType, String ... fields) {
        SchemaBuilder builder = SchemaBuilder.struct().name("io.debezium.connector.mysql.Data");
        for (String field : fields) {
            builder.field(field, schema.field(field).schema());
        }
        return builder.build();
    }

    public Struct data() {
        Struct data = new Struct(this.dataSchema());
        for (Field field : this.dataSchema.fields()) {
            data.put(field, this.record.get(field));
        }
        return data;
    }

    public Struct source() {
        return this.source;
    }

    public Struct transaction() {
        return this.transaction;
    }

    public String op() {
        return this.op;
    }

    public Schema opSchema() {
        return this.opSchema;
    }

    public String ts_ms() {
        return this.ts_ms;
    }

    public Schema ts_msSchema() {
        return this.ts_msSchema;
    }

    public Schema dataSchema() {
        return this.dataSchema;
    }

    public String connectorType() {
        return this.connectorType;
    }

    public abstract Object getMetadata(String var1);

    public static final class SqlserverRecordParser
    extends RecordParser {
        static final String CHANGE_LSN_KEY = "change_lsn";
        static final String COMMIT_LSN_KEY = "commit_lsn";
        static final String EVENT_SERIAL_NO_KEY = "event_serial_no";
        static final Set<String> SQLSERVER_SOURCE_FIELD = Collect.unmodifiableSet("change_lsn", "commit_lsn", "event_serial_no");

        SqlserverRecordParser(Schema schema, Struct record) {
            super(schema, record, "before", "after");
        }

        @Override
        public Object getMetadata(String name) {
            if (SOURCE_FIELDS.contains(name)) {
                return this.source().get(name);
            }
            if (SQLSERVER_SOURCE_FIELD.contains(name)) {
                return this.source().get(name);
            }
            throw new DataException("No such field \"" + name + "\" in the \"source\" field of events from SQLServer connector");
        }
    }

    public static final class MongodbRecordParser
    extends RecordParser {
        static final String REPLICA_SET_NAME = "rs";
        static final String ORDER = "ord";
        static final String OPERATION_ID = "h";
        static final String COLLECTION = "collection";
        static final Set<String> MONGODB_SOURCE_FIELD = Collect.unmodifiableSet("rs", "ord", "h", "collection");

        MongodbRecordParser(Schema schema, Struct record) {
            super(schema, record, "after", "patch");
        }

        @Override
        public Object getMetadata(String name) {
            if (SOURCE_FIELDS.contains(name)) {
                return this.source().get(name);
            }
            if (MONGODB_SOURCE_FIELD.contains(name)) {
                return this.source().get(name);
            }
            throw new DataException("No such field \"" + name + "\" in the \"source\" field of events from MongoDB connector");
        }
    }

    public static final class PostgresRecordParser
    extends RecordParser {
        static final String TXID_KEY = "txId";
        static final String XMIN_KEY = "xmin";
        static final String LSN_KEY = "lsn";
        static final Set<String> POSTGRES_SOURCE_FIELD = Collect.unmodifiableSet("txId", "xmin", "lsn");

        PostgresRecordParser(Schema schema, Struct record) {
            super(schema, record, "before", "after");
        }

        @Override
        public Object getMetadata(String name) {
            if (SOURCE_FIELDS.contains(name)) {
                return this.source().get(name);
            }
            if (POSTGRES_SOURCE_FIELD.contains(name)) {
                return this.source().get(name);
            }
            throw new DataException("No such field \"" + name + "\" in the \"source\" field of events from PostgreSQL connector");
        }
    }

    public static final class MysqlRecordParser
    extends RecordParser {
        static final String TABLE_NAME_KEY = "table";
        static final String SERVER_ID_KEY = "server_id";
        static final String GTID_KEY = "gtid";
        static final String BINLOG_FILENAME_OFFSET_KEY = "file";
        static final String BINLOG_POSITION_OFFSET_KEY = "pos";
        static final String BINLOG_ROW_IN_EVENT_OFFSET_KEY = "row";
        static final String THREAD_KEY = "thread";
        static final String QUERY_KEY = "query";
        static final Set<String> MYSQL_SOURCE_FIELDS = Collect.unmodifiableSet("table", "server_id", "gtid", "file", "pos", "row", "thread", "query");

        MysqlRecordParser(Schema schema, Struct record) {
            super(schema, record, "before", "after");
        }

        @Override
        public Object getMetadata(String name) {
            if (SOURCE_FIELDS.contains(name)) {
                return this.source().get(name);
            }
            if (MYSQL_SOURCE_FIELDS.contains(name)) {
                return this.source().get(name);
            }
            throw new DataException("No such field \"" + name + "\" in the \"source\" field of events from MySQL connector");
        }
    }
}

