/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.source.splitters;

import io.debezium.relational.TableId;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.cdc.base.source.split.SnapshotSplit;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.source.splitters.SplitContext;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.source.splitters.SplitStrategy;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.utils.ChunkUtils;

public enum SingleSplitStrategy implements SplitStrategy
{
    INSTANCE;


    @Override
    public Collection<SnapshotSplit> split(@Nonnull SplitContext splitContext) {
        TableId collectionId = splitContext.getCollectionId();
        SnapshotSplit snapshotSplit = this.createSnapshotSplit(collectionId);
        return Collections.singletonList(snapshotSplit);
    }

    @Nonnull
    private SnapshotSplit createSnapshotSplit(TableId collectionId) {
        SeaTunnelRowType rowType = this.shardKeysToRowType(Collections.singleton("_id"));
        return new SnapshotSplit(this.splitId(collectionId, 0), collectionId, rowType, ChunkUtils.minLowerBoundOfId(), ChunkUtils.maxUpperBoundOfId());
    }
}

