/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.utils;

import com.mongodb.kafka.connect.source.json.formatter.DefaultJson;
import com.mongodb.kafka.connect.source.schema.AvroSchema;
import com.mongodb.kafka.connect.source.schema.BsonValueToSchemaAndValue;
import io.debezium.relational.TableId;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.seatunnel.connectors.cdc.base.source.split.wartermark.WatermarkEvent;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.json.JsonWriterSettings;

public class MongodbRecordUtils {
    public static boolean isHeartbeatEvent(SourceRecord sourceRecord) {
        return "true".equals(MongodbRecordUtils.getOffsetValue(sourceRecord, "copy"));
    }

    public static boolean isDataChangeRecord(SourceRecord sourceRecord) {
        return !WatermarkEvent.isWatermarkEvent(sourceRecord) && !MongodbRecordUtils.isHeartbeatEvent(sourceRecord);
    }

    public static BsonDocument getResumeToken(SourceRecord sourceRecord) {
        return BsonDocument.parse(MongodbRecordUtils.getOffsetValue(sourceRecord, "_id"));
    }

    public static BsonDocument getDocumentKey(@Nonnull SourceRecord sourceRecord) {
        Struct value = (Struct)sourceRecord.value();
        return MongodbRecordUtils.extractBsonDocument(value, sourceRecord.valueSchema(), "documentKey");
    }

    public static BsonDocument extractBsonDocument(Struct value, @Nonnull Schema valueSchema, String fieldName) {
        String docString;
        if (valueSchema.field(fieldName) != null && (docString = value.getString(fieldName)) != null) {
            return BsonDocument.parse(docString);
        }
        return null;
    }

    public static String getOffsetValue(@Nonnull SourceRecord sourceRecord, String key) {
        return (String)sourceRecord.sourceOffset().get(key);
    }

    @Nonnull
    public static TableId getTableId(@Nonnull SourceRecord dataRecord) {
        Struct value = (Struct)dataRecord.value();
        Struct source = value.getStruct("ns");
        String dbName = source.getString("db");
        String collName = source.getString("coll");
        return new TableId(dbName, null, collName);
    }

    @Nonnull
    public static BsonTimestamp currentBsonTimestamp() {
        return MongodbRecordUtils.bsonTimestampFromEpochMillis(System.currentTimeMillis());
    }

    @Nonnull
    public static BsonTimestamp maximumBsonTimestamp() {
        return new BsonTimestamp(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Nonnull
    public static BsonTimestamp bsonTimestampFromEpochMillis(long epochMillis) {
        return new BsonTimestamp((int)Instant.ofEpochMilli(epochMillis).getEpochSecond(), 1);
    }

    @Nonnull
    public static SourceRecord buildSourceRecord(Map<String, String> partition, Map<String, String> sourceOffset, String topicName, BsonDocument keyDocument, BsonDocument valueDocument) {
        return MongodbRecordUtils.buildSourceRecord(partition, sourceOffset, topicName, keyDocument, valueDocument, new DefaultJson().getJsonWriterSettings());
    }

    @Nonnull
    public static SourceRecord buildSourceRecord(Map<String, String> partition, Map<String, String> sourceOffset, String topicName, BsonDocument keyDocument, BsonDocument valueDocument, JsonWriterSettings jsonWriterSettings) {
        BsonValueToSchemaAndValue schemaAndValue = new BsonValueToSchemaAndValue(jsonWriterSettings);
        SchemaAndValue keySchemaAndValue = schemaAndValue.toSchemaAndValue(AvroSchema.fromJson("{  \"type\": \"record\",  \"name\": \"keySchema\",  \"fields\" : [{\"name\": \"_id\", \"type\": \"string\"}]}"), keyDocument);
        BsonDocument source = valueDocument.get("source").asDocument();
        BsonValue table = valueDocument.get("ns").asDocument().get("coll");
        BsonValue db = valueDocument.get("ns").asDocument().get("db");
        source.append("table", table);
        source.append("db", db);
        valueDocument.replace("source", source);
        SchemaAndValue valueSchemaAndValue = schemaAndValue.toSchemaAndValue(AvroSchema.fromJson("{  \"name\": \"ChangeStream\",  \"type\": \"record\",  \"fields\": [    { \"name\": \"_id\", \"type\": \"string\" },    { \"name\": \"operationType\", \"type\": [\"string\", \"null\"] },    { \"name\": \"fullDocument\", \"type\": [\"string\", \"null\"] },    { \"name\": \"source\",      \"type\": [{\"name\": \"source\", \"type\": \"record\", \"fields\": [                {\"name\": \"ts_ms\", \"type\": \"long\"},                {\"name\": \"table\", \"type\": [\"string\", \"null\"]},                {\"name\": \"db\", \"type\": [\"string\", \"null\"]},                {\"name\": \"snapshot\", \"type\": [\"string\", \"null\"] } ]               }, \"null\" ] },    { \"name\": \"ts_ms\", \"type\": [\"long\", \"null\"]},    { \"name\": \"ns\",      \"type\": [{\"name\": \"ns\", \"type\": \"record\", \"fields\": [                {\"name\": \"db\", \"type\": \"string\"},                {\"name\": \"coll\", \"type\": [\"string\", \"null\"] } ]               }, \"null\" ] },    { \"name\": \"to\",      \"type\": [{\"name\": \"to\", \"type\": \"record\",  \"fields\": [                {\"name\": \"db\", \"type\": \"string\"},                {\"name\": \"coll\", \"type\": [\"string\", \"null\"] } ]               }, \"null\" ] },    { \"name\": \"documentKey\", \"type\": [\"string\", \"null\"] },    { \"name\": \"updateDescription\",      \"type\": [{\"name\": \"updateDescription\",  \"type\": \"record\", \"fields\": [                 {\"name\": \"updatedFields\", \"type\": [\"string\", \"null\"]},                 {\"name\": \"removedFields\",                  \"type\": [{\"type\": \"array\", \"items\": \"string\"}, \"null\"]                  }] }, \"null\"] },    { \"name\": \"clusterTime\", \"type\": [\"string\", \"null\"] },    { \"name\": \"txnNumber\", \"type\": [\"long\", \"null\"]},    { \"name\": \"lsid\", \"type\": [{\"name\": \"lsid\", \"type\": \"record\",               \"fields\": [ {\"name\": \"id\", \"type\": \"string\"},                             {\"name\": \"uid\", \"type\": \"string\"}] }, \"null\"] }  ]}"), valueDocument);
        return new SourceRecord(partition, sourceOffset, topicName, keySchemaAndValue.schema(), keySchemaAndValue.value(), valueSchemaAndValue.schema(), valueSchemaAndValue.value());
    }

    @Nonnull
    public static SourceRecord buildSourceRecord(Map<String, ?> sourcePartition, Map<String, ?> sourceOffset, String topicName, Integer partition, Schema keySchema, Object key, BsonDocument valueDocument) {
        BsonValueToSchemaAndValue schemaAndValue = new BsonValueToSchemaAndValue(new DefaultJson().getJsonWriterSettings());
        SchemaAndValue valueSchemaAndValue = schemaAndValue.toSchemaAndValue(AvroSchema.fromJson("{  \"name\": \"ChangeStream\",  \"type\": \"record\",  \"fields\": [    { \"name\": \"_id\", \"type\": \"string\" },    { \"name\": \"operationType\", \"type\": [\"string\", \"null\"] },    { \"name\": \"fullDocument\", \"type\": [\"string\", \"null\"] },    { \"name\": \"source\",      \"type\": [{\"name\": \"source\", \"type\": \"record\", \"fields\": [                {\"name\": \"ts_ms\", \"type\": \"long\"},                {\"name\": \"table\", \"type\": [\"string\", \"null\"]},                {\"name\": \"db\", \"type\": [\"string\", \"null\"]},                {\"name\": \"snapshot\", \"type\": [\"string\", \"null\"] } ]               }, \"null\" ] },    { \"name\": \"ts_ms\", \"type\": [\"long\", \"null\"]},    { \"name\": \"ns\",      \"type\": [{\"name\": \"ns\", \"type\": \"record\", \"fields\": [                {\"name\": \"db\", \"type\": \"string\"},                {\"name\": \"coll\", \"type\": [\"string\", \"null\"] } ]               }, \"null\" ] },    { \"name\": \"to\",      \"type\": [{\"name\": \"to\", \"type\": \"record\",  \"fields\": [                {\"name\": \"db\", \"type\": \"string\"},                {\"name\": \"coll\", \"type\": [\"string\", \"null\"] } ]               }, \"null\" ] },    { \"name\": \"documentKey\", \"type\": [\"string\", \"null\"] },    { \"name\": \"updateDescription\",      \"type\": [{\"name\": \"updateDescription\",  \"type\": \"record\", \"fields\": [                 {\"name\": \"updatedFields\", \"type\": [\"string\", \"null\"]},                 {\"name\": \"removedFields\",                  \"type\": [{\"type\": \"array\", \"items\": \"string\"}, \"null\"]                  }] }, \"null\"] },    { \"name\": \"clusterTime\", \"type\": [\"string\", \"null\"] },    { \"name\": \"txnNumber\", \"type\": [\"long\", \"null\"]},    { \"name\": \"lsid\", \"type\": [{\"name\": \"lsid\", \"type\": \"record\",               \"fields\": [ {\"name\": \"id\", \"type\": \"string\"},                             {\"name\": \"uid\", \"type\": \"string\"}] }, \"null\"] }  ]}"), valueDocument);
        return new SourceRecord(sourcePartition, sourceOffset, topicName, partition, keySchema, key, valueSchemaAndValue.schema(), valueSchemaAndValue.value());
    }

    @Nonnull
    public static Map<String, String> createSourceOffsetMap(@Nonnull BsonDocument idDocument, boolean isSnapshotRecord) {
        HashMap<String, String> sourceOffset = new HashMap<String, String>();
        sourceOffset.put("_id", idDocument.toJson());
        sourceOffset.put("copy", String.valueOf(isSnapshotRecord));
        return sourceOffset;
    }

    @Nonnull
    public static Map<String, String> createPartitionMap(String hosts, String database, String collection) {
        StringBuilder builder = new StringBuilder();
        builder.append("mongodb://");
        builder.append(hosts);
        builder.append("/");
        if (StringUtils.isNotEmpty(database)) {
            builder.append(database);
        }
        if (StringUtils.isNotEmpty(collection)) {
            builder.append(".");
            builder.append(collection);
        }
        return Collections.singletonMap("ns", builder.toString());
    }

    @Nonnull
    public static Map<String, Object> createHeartbeatPartitionMap(String hosts) {
        String builder = "mongodb://" + hosts + "/__mongodb_heartbeats";
        return Collections.singletonMap("ns", builder);
    }

    @Nonnull
    public static Map<String, String> createWatermarkPartitionMap(String partition) {
        return Collections.singletonMap("ns", partition);
    }
}

