/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.connect.sink.SinkRecord;

class RecordBatches {
    private int batchSize;
    private int currentBatch = 0;
    private List<List<SinkRecord>> bufferedBatches = new ArrayList<List<SinkRecord>>();

    RecordBatches(int batchSize, int records) {
        this.batchSize = batchSize;
        this.bufferedBatches.add(batchSize > 0 ? new ArrayList(batchSize) : new ArrayList(records));
    }

    void buffer(SinkRecord record) {
        if (this.batchSize > 0) {
            if (this.bufferedBatches.get(this.currentBatch).size() < this.batchSize) {
                this.bufferedBatches.get(this.currentBatch).add(record);
            } else {
                this.bufferedBatches.add(new ArrayList(this.batchSize));
                this.bufferedBatches.get(++this.currentBatch).add(record);
            }
        } else {
            this.bufferedBatches.get(0).add(record);
        }
    }

    List<List<SinkRecord>> getBufferedBatches() {
        return this.bufferedBatches;
    }
}

