/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.utils;

import java.time.Duration;
import org.apache.seatunnel.shade.com.google.common.util.concurrent.RateLimiter;

public class MessageDelayedEventLimiter {
    private final long delayMs;
    private final RateLimiter eventRateLimiter;

    public MessageDelayedEventLimiter(Duration delayThreshold) {
        this(delayThreshold, 1.0);
    }

    public MessageDelayedEventLimiter(Duration delayThreshold, double permitsPerSecond) {
        this.delayMs = delayThreshold.toMillis();
        this.eventRateLimiter = RateLimiter.create((double)permitsPerSecond);
    }

    public boolean acquire(long messageCreateTime) {
        if (this.isDelayed(messageCreateTime)) {
            return this.eventRateLimiter.tryAcquire();
        }
        return false;
    }

    private boolean isDelayed(long messageCreateTime) {
        return this.delayMs != 0L && System.currentTimeMillis() - messageCreateTime >= this.delayMs;
    }

    public MessageDelayedEventLimiter(long delayMs, RateLimiter eventRateLimiter) {
        this.delayMs = delayMs;
        this.eventRateLimiter = eventRateLimiter;
    }
}

