/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.annotation.Immutable;
import io.debezium.relational.Selectors;
import io.debezium.relational.TableIdParser;
import io.debezium.schema.DataCollectionId;
import java.io.Serializable;

@Immutable
public final class TableId
implements DataCollectionId,
Comparable<TableId>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final String id;

    public static TableId parse(String str) {
        return TableId.parse(str, true);
    }

    public static TableId parse(String str, boolean useCatalogBeforeSchema) {
        String[] parts = TableIdParser.parse(str).toArray(new String[0]);
        return TableId.parse(parts, parts.length, useCatalogBeforeSchema);
    }

    protected static TableId parse(String[] parts, int numParts, boolean useCatalogBeforeSchema) {
        if (numParts == 0) {
            return null;
        }
        if (numParts == 1) {
            return new TableId(null, null, parts[0]);
        }
        if (numParts == 2) {
            if (useCatalogBeforeSchema) {
                return new TableId(parts[0], null, parts[1]);
            }
            return new TableId(null, parts[0], parts[1]);
        }
        return new TableId(parts[0], parts[1], parts[2]);
    }

    public TableId(String catalogName, String schemaName, String tableName, Selectors.TableIdToStringMapper tableIdMapper) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        assert (this.tableName != null);
        this.id = tableIdMapper == null ? TableId.tableId(this.catalogName, this.schemaName, this.tableName) : tableIdMapper.toString(this);
    }

    public TableId(String catalogName, String schemaName, String tableName) {
        this(catalogName, schemaName, tableName, null);
    }

    public String catalog() {
        return this.catalogName;
    }

    public String schema() {
        return this.schemaName;
    }

    public String table() {
        return this.tableName;
    }

    @Override
    public String identifier() {
        return this.id;
    }

    @Override
    public int compareTo(TableId that) {
        if (this == that) {
            return 0;
        }
        return this.id.compareTo(that.id);
    }

    public int compareToIgnoreCase(TableId that) {
        if (this == that) {
            return 0;
        }
        return this.id.compareToIgnoreCase(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TableId) {
            return this.compareTo((TableId)obj) == 0;
        }
        return false;
    }

    public String toString() {
        return this.identifier();
    }

    public String toDoubleQuotedString() {
        return this.toQuotedString('\"');
    }

    public TableId toDoubleQuoted() {
        return this.toQuoted('\"');
    }

    public TableId toQuoted(char quotingChar) {
        String catalogName = null;
        if (this.catalogName != null && !this.catalogName.isEmpty()) {
            catalogName = TableId.quote(this.catalogName, quotingChar);
        }
        String schemaName = null;
        if (this.schemaName != null && !this.schemaName.isEmpty()) {
            schemaName = TableId.quote(this.schemaName, quotingChar);
        }
        return new TableId(catalogName, schemaName, TableId.quote(this.tableName, quotingChar));
    }

    public String toQuotedString(char quotingChar) {
        StringBuilder quoted = new StringBuilder();
        if (this.catalogName != null && !this.catalogName.isEmpty()) {
            quoted.append(TableId.quote(this.catalogName, quotingChar)).append(".");
        }
        if (this.schemaName != null && !this.schemaName.isEmpty()) {
            quoted.append(TableId.quote(this.schemaName, quotingChar)).append(".");
        }
        quoted.append(TableId.quote(this.tableName, quotingChar));
        return quoted.toString();
    }

    private static String tableId(String catalog, String schema, String table) {
        if (catalog == null || catalog.length() == 0) {
            if (schema == null || schema.length() == 0) {
                return table;
            }
            return schema + "." + table;
        }
        if (schema == null || schema.length() == 0) {
            return catalog + "." + table;
        }
        return catalog + "." + schema + "." + table;
    }

    private static String quote(String identifierPart, char quotingChar) {
        if (identifierPart == null) {
            return null;
        }
        if (identifierPart.isEmpty()) {
            return "" + quotingChar + quotingChar;
        }
        if (identifierPart.charAt(0) != quotingChar && identifierPart.charAt(identifierPart.length() - 1) != quotingChar) {
            identifierPart = identifierPart.replace(quotingChar + "", TableId.repeat(quotingChar));
            identifierPart = quotingChar + identifierPart + quotingChar;
        }
        return identifierPart;
    }

    private static String repeat(char quotingChar) {
        return "" + quotingChar + quotingChar;
    }

    public TableId toLowercase() {
        return new TableId(this.catalogName, this.schemaName, this.tableName.toLowerCase());
    }
}

