/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.config;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.cdc.base.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.cdc.base.config.SourceConfig;
import org.apache.seatunnel.connectors.cdc.base.config.StartupConfig;
import org.apache.seatunnel.connectors.cdc.base.config.StopConfig;
import org.apache.seatunnel.connectors.cdc.base.option.JdbcSourceOptions;
import org.apache.seatunnel.connectors.cdc.base.option.SourceOptions;

public abstract class JdbcSourceConfigFactory
implements SourceConfig.Factory<JdbcSourceConfig> {
    private static final long serialVersionUID = 1L;
    protected int port;
    protected String hostname;
    protected String username;
    protected String password;
    protected List<String> databaseList;
    protected List<String> tableList;
    protected StartupConfig startupConfig;
    protected StopConfig stopConfig;
    protected boolean includeSchemaChanges = false;
    protected double distributionFactorUpper = 1000.0;
    protected double distributionFactorLower = 0.05;
    protected int splitSize = (Integer)SourceOptions.SNAPSHOT_SPLIT_SIZE.defaultValue();
    protected int fetchSize = (Integer)SourceOptions.SNAPSHOT_FETCH_SIZE.defaultValue();
    protected String serverTimeZone = (String)JdbcSourceOptions.SERVER_TIME_ZONE.defaultValue();
    protected Duration connectTimeout = (Duration)JdbcSourceOptions.CONNECT_TIMEOUT.defaultValue();
    protected int connectMaxRetries = (Integer)JdbcSourceOptions.CONNECT_MAX_RETRIES.defaultValue();
    protected int connectionPoolSize = (Integer)JdbcSourceOptions.CONNECTION_POOL_SIZE.defaultValue();
    protected Properties dbzProperties;

    public JdbcSourceConfigFactory hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public JdbcSourceConfigFactory port(int port) {
        this.port = port;
        return this;
    }

    public JdbcSourceConfigFactory databaseList(String ... databaseList) {
        this.databaseList = Arrays.asList(databaseList);
        return this;
    }

    public JdbcSourceConfigFactory tableList(String ... tableList) {
        this.tableList = Arrays.asList(tableList);
        return this;
    }

    public JdbcSourceConfigFactory username(String username) {
        this.username = username;
        return this;
    }

    public JdbcSourceConfigFactory password(String password) {
        this.password = password;
        return this;
    }

    public JdbcSourceConfigFactory serverTimeZone(String timeZone) {
        this.serverTimeZone = timeZone;
        return this;
    }

    public JdbcSourceConfigFactory splitSize(int splitSize) {
        this.splitSize = splitSize;
        return this;
    }

    public JdbcSourceConfigFactory distributionFactorUpper(double distributionFactorUpper) {
        this.distributionFactorUpper = distributionFactorUpper;
        return this;
    }

    public JdbcSourceConfigFactory distributionFactorLower(double distributionFactorLower) {
        this.distributionFactorLower = distributionFactorLower;
        return this;
    }

    public JdbcSourceConfigFactory fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public JdbcSourceConfigFactory connectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public JdbcSourceConfigFactory connectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
        return this;
    }

    public JdbcSourceConfigFactory connectMaxRetries(int connectMaxRetries) {
        this.connectMaxRetries = connectMaxRetries;
        return this;
    }

    public JdbcSourceConfigFactory includeSchemaChanges(boolean includeSchemaChanges) {
        this.includeSchemaChanges = includeSchemaChanges;
        return this;
    }

    public JdbcSourceConfigFactory debeziumProperties(Properties properties) {
        this.dbzProperties = properties;
        return this;
    }

    public JdbcSourceConfigFactory startupOptions(StartupConfig startupConfig) {
        this.startupConfig = startupConfig;
        return this;
    }

    public JdbcSourceConfigFactory stopOptions(StopConfig stopConfig) {
        this.stopConfig = stopConfig;
        return this;
    }

    public JdbcSourceConfigFactory fromReadonlyConfig(ReadonlyConfig config) {
        this.port = (Integer)config.get(JdbcSourceOptions.PORT);
        this.hostname = (String)config.get(JdbcSourceOptions.HOSTNAME);
        this.username = (String)config.get(JdbcSourceOptions.USERNAME);
        this.password = (String)config.get(JdbcSourceOptions.PASSWORD);
        this.databaseList = Collections.singletonList(config.get(JdbcSourceOptions.DATABASE_NAME));
        this.tableList = Collections.singletonList((String)config.get(JdbcSourceOptions.DATABASE_NAME) + "." + (String)config.get(JdbcSourceOptions.TABLE_NAME));
        this.distributionFactorUpper = (Double)config.get(JdbcSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND);
        this.distributionFactorLower = (Double)config.get(JdbcSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND);
        this.splitSize = (Integer)config.get(SourceOptions.SNAPSHOT_SPLIT_SIZE);
        this.fetchSize = (Integer)config.get(SourceOptions.SNAPSHOT_FETCH_SIZE);
        this.serverTimeZone = (String)config.get(JdbcSourceOptions.SERVER_TIME_ZONE);
        this.connectTimeout = (Duration)config.get(JdbcSourceOptions.CONNECT_TIMEOUT);
        this.connectMaxRetries = (Integer)config.get(JdbcSourceOptions.CONNECT_MAX_RETRIES);
        this.connectionPoolSize = (Integer)config.get(JdbcSourceOptions.CONNECTION_POOL_SIZE);
        this.dbzProperties = new Properties();
        config.getOptional(SourceOptions.DEBEZIUM_PROPERTIES).ifPresent(map -> this.dbzProperties.putAll((Map<?, ?>)map));
        return this;
    }

    @Override
    public abstract JdbcSourceConfig create(int var1);
}

