/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.option;

import java.util.Map;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.connectors.cdc.base.option.StartupMode;
import org.apache.seatunnel.connectors.cdc.base.option.StopMode;

public class SourceOptions {
    public static final Option<Integer> SNAPSHOT_SPLIT_SIZE = Options.key((String)"snapshot.split.size").intType().defaultValue((Object)8096).withDescription("The split size (number of rows) of table snapshot, captured tables are split into multiple splits when read the snapshot of table.");
    public static final Option<Integer> SNAPSHOT_FETCH_SIZE = Options.key((String)"snapshot.fetch.size").intType().defaultValue((Object)1024).withDescription("The maximum fetch size for per poll when read table snapshot.");
    public static final Option<StartupMode> STARTUP_MODE = Options.key((String)"startup.mode").enumType(StartupMode.class).defaultValue((Object)StartupMode.INITIAL).withDescription("Optional startup mode for CDC source, valid enumerations are \"initial\", \"earliest\", \"latest\", \"timestamp\"\n or \"specific\"");
    public static final Option<Long> STARTUP_TIMESTAMP = Options.key((String)"startup.timestamp").longType().noDefaultValue().withDescription("Optional timestamp(mills) used in case of \"timestamp\" startup mode");
    public static final Option<String> STARTUP_SPECIFIC_OFFSET_FILE = Options.key((String)"startup.specific-offset.file").stringType().noDefaultValue().withDescription("Optional offsets used in case of \"specific\" startup mode");
    public static final Option<Long> STARTUP_SPECIFIC_OFFSET_POS = Options.key((String)"startup.specific-offset.pos").longType().noDefaultValue().withDescription("Optional offsets used in case of \"specific\" startup mode");
    public static final Option<Integer> INCREMENTAL_PARALLELISM = Options.key((String)"incremental.parallelism").intType().defaultValue((Object)1).withDescription("The number of parallel readers in the incremental phase.");
    public static final Option<StopMode> STOP_MODE = Options.key((String)"stop.mode").enumType(StopMode.class).defaultValue((Object)StopMode.NEVER).withDescription("Optional stop mode for CDC source, valid enumerations are \"never\", \"latest\", \"timestamp\"\n or \"specific\"");
    public static final Option<Long> STOP_TIMESTAMP = Options.key((String)"stop.timestamp").longType().noDefaultValue().withDescription("Optional timestamp(mills) used in case of \"timestamp\" stop mode");
    public static final Option<String> STOP_SPECIFIC_OFFSET_FILE = Options.key((String)"stop.specific-offset.file").stringType().noDefaultValue().withDescription("Optional offsets used in case of \"specific\" stop mode");
    public static final Option<Long> STOP_SPECIFIC_OFFSET_POS = Options.key((String)"stop.specific-offset.pos").longType().noDefaultValue().withDescription("Optional offsets used in case of \"specific\" stop mode");
    public static final Option<Map<String, String>> DEBEZIUM_PROPERTIES = Options.key((String)"debezium").mapType().noDefaultValue().withDescription("Decides if the table options contains Debezium client properties that start with prefix 'debezium'.");
    public static final OptionRule.Builder BASE_RULE = OptionRule.builder().optional(new Option[]{SNAPSHOT_SPLIT_SIZE, SNAPSHOT_FETCH_SIZE}).optional(new Option[]{INCREMENTAL_PARALLELISM}).optional(new Option[]{STARTUP_MODE, STOP_MODE}).optional(new Option[]{DEBEZIUM_PROPERTIES}).conditional(STARTUP_MODE, (Object)StartupMode.TIMESTAMP, new Option[]{STARTUP_TIMESTAMP}).conditional(STARTUP_MODE, (Object)StartupMode.SPECIFIC, new Option[]{STARTUP_SPECIFIC_OFFSET_FILE, STARTUP_SPECIFIC_OFFSET_POS}).conditional(STOP_MODE, (Object)StopMode.TIMESTAMP, new Option[]{STOP_TIMESTAMP}).conditional(STOP_MODE, (Object)StopMode.SPECIFIC, new Option[]{STOP_SPECIFIC_OFFSET_FILE, STOP_SPECIFIC_OFFSET_POS});
}

