/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.source.reader.external;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.pipeline.DataChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.connectors.cdc.base.source.offset.Offset;
import org.apache.seatunnel.connectors.cdc.base.source.reader.external.FetchTask;
import org.apache.seatunnel.connectors.cdc.base.source.reader.external.Fetcher;
import org.apache.seatunnel.connectors.cdc.base.source.split.IncrementalSplit;
import org.apache.seatunnel.connectors.cdc.base.source.split.SourceRecords;
import org.apache.seatunnel.connectors.cdc.base.source.split.SourceSplitBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalSourceStreamFetcher
implements Fetcher<SourceRecords, SourceSplitBase> {
    private static final Logger log = LoggerFactory.getLogger(IncrementalSourceStreamFetcher.class);
    private final FetchTask.Context taskContext;
    private final ExecutorService executorService;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile Throwable readException;
    private FetchTask<SourceSplitBase> streamFetchTask;
    private IncrementalSplit currentIncrementalSplit;
    private Offset splitStartWatermark;
    private static final long READER_CLOSE_TIMEOUT_SECONDS = 30L;

    public IncrementalSourceStreamFetcher(FetchTask.Context taskContext, int subTaskId) {
        this.taskContext = taskContext;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("debezium-reader-" + subTaskId).build();
        this.executorService = Executors.newSingleThreadExecutor(threadFactory);
    }

    @Override
    public void submitTask(FetchTask<SourceSplitBase> fetchTask) {
        this.streamFetchTask = fetchTask;
        this.currentIncrementalSplit = fetchTask.getSplit().asIncrementalSplit();
        this.configureFilter();
        this.taskContext.configure(this.currentIncrementalSplit);
        this.queue = this.taskContext.getQueue();
        this.executorService.submit(() -> {
            try {
                this.streamFetchTask.execute(this.taskContext);
            }
            catch (Exception e) {
                log.error(String.format("Execute stream read task for incremental split %s fail", this.currentIncrementalSplit), (Throwable)e);
                this.readException = e;
            }
        });
    }

    @Override
    public boolean isFinished() {
        return this.currentIncrementalSplit == null || !this.streamFetchTask.isRunning();
    }

    @Override
    public Iterator<SourceRecords> pollSplitRecords() throws InterruptedException {
        this.checkReadException();
        ArrayList<SourceRecord> sourceRecords = new ArrayList<SourceRecord>();
        if (this.streamFetchTask.isRunning()) {
            List<DataChangeEvent> batch = this.queue.poll();
            for (DataChangeEvent event : batch) {
                if (!this.shouldEmit(event.getRecord())) continue;
                sourceRecords.add(event.getRecord());
            }
        }
        ArrayList<SourceRecords> sourceRecordsSet = new ArrayList<SourceRecords>();
        sourceRecordsSet.add(new SourceRecords(sourceRecords));
        return sourceRecordsSet.iterator();
    }

    private void checkReadException() {
        if (this.readException != null) {
            throw new SeaTunnelException(String.format("Read split %s error due to %s.", this.currentIncrementalSplit, this.readException.getMessage()), this.readException);
        }
    }

    @Override
    public void close() {
        try {
            if (this.executorService != null) {
                this.executorService.shutdown();
                if (this.executorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                    log.warn("Failed to close the stream fetcher in {} seconds.", (Object)30L);
                }
            }
        }
        catch (Exception e) {
            log.error("Close stream fetcher error", (Throwable)e);
        }
    }

    private boolean shouldEmit(SourceRecord sourceRecord) {
        if (this.taskContext.isDataChangeRecord(sourceRecord)) {
            Offset position = this.taskContext.getStreamOffset(sourceRecord);
            return position.isAtOrAfter(this.splitStartWatermark);
        }
        return true;
    }

    private void configureFilter() {
        this.splitStartWatermark = this.currentIncrementalSplit.getStartupOffset();
    }
}

