/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.utils;

import io.debezium.document.DocumentReader;
import io.debezium.relational.TableId;
import io.debezium.util.SchemaNameAdjuster;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;

public class SourceRecordUtils {
    public static final String SCHEMA_CHANGE_EVENT_KEY_NAME = "io.debezium.connector.mysql.SchemaChangeKey";
    private static final DocumentReader DOCUMENT_READER = DocumentReader.defaultReader();

    private SourceRecordUtils() {
    }

    public static Object[] rowToArray(ResultSet rs, int size) throws SQLException {
        Object[] row = new Object[size];
        for (int i = 0; i < size; ++i) {
            row[i] = rs.getObject(i + 1);
        }
        return row;
    }

    public static Long getMessageTimestamp(SourceRecord record) {
        Schema schema = record.valueSchema();
        Struct value = (Struct)record.value();
        if (schema.field("source") == null) {
            return null;
        }
        Struct source = value.getStruct("source");
        if (source.schema().field("ts_ms") == null) {
            return null;
        }
        return source.getInt64("ts_ms");
    }

    public static Long getFetchTimestamp(SourceRecord record) {
        Schema schema = record.valueSchema();
        Struct value = (Struct)record.value();
        if (schema.field("ts_ms") == null) {
            return null;
        }
        return value.getInt64("ts_ms");
    }

    public static boolean isSchemaChangeEvent(SourceRecord sourceRecord) {
        Schema keySchema = sourceRecord.keySchema();
        return keySchema != null && SCHEMA_CHANGE_EVENT_KEY_NAME.equalsIgnoreCase(keySchema.name());
    }

    public static boolean isDataChangeRecord(SourceRecord record) {
        Schema valueSchema = record.valueSchema();
        Struct value = (Struct)record.value();
        return valueSchema.field("op") != null && value.getString("op") != null;
    }

    public static TableId getTableId(SourceRecord dataRecord) {
        Struct value = (Struct)dataRecord.value();
        Struct source = value.getStruct("source");
        String dbName = source.getString("db");
        String schemaName = SourceRecordUtils.getSchemaName(source);
        String tableName = source.getString("table");
        return new TableId(dbName, schemaName, tableName);
    }

    public static String getSchemaName(Struct source) {
        if (source.schema().fields().stream().anyMatch(r -> "schema".equals(r.name()))) {
            return source.getString("schema");
        }
        return null;
    }

    public static Object[] getSplitKey(SeaTunnelRowType splitBoundaryType, SourceRecord dataRecord, SchemaNameAdjuster nameAdjuster) {
        String splitFieldName = nameAdjuster.adjust(splitBoundaryType.getFieldNames()[0]);
        Struct key = (Struct)dataRecord.key();
        return new Object[]{key.get(splitFieldName)};
    }

    public static boolean splitKeyRangeContains(Object[] key, Object[] splitKeyStart, Object[] splitKeyEnd) {
        if (splitKeyStart == null && splitKeyEnd == null) {
            return true;
        }
        if (splitKeyStart == null) {
            int[] upperBoundRes = new int[key.length];
            for (int i = 0; i < key.length; ++i) {
                upperBoundRes[i] = SourceRecordUtils.compareObjects(key[i], splitKeyEnd[i]);
            }
            return Arrays.stream(upperBoundRes).anyMatch(value -> value < 0) && Arrays.stream(upperBoundRes).allMatch(value -> value <= 0);
        }
        if (splitKeyEnd == null) {
            int[] lowerBoundRes = new int[key.length];
            for (int i = 0; i < key.length; ++i) {
                lowerBoundRes[i] = SourceRecordUtils.compareObjects(key[i], splitKeyStart[i]);
            }
            return Arrays.stream(lowerBoundRes).allMatch(value -> value >= 0);
        }
        int[] lowerBoundRes = new int[key.length];
        int[] upperBoundRes = new int[key.length];
        for (int i = 0; i < key.length; ++i) {
            lowerBoundRes[i] = SourceRecordUtils.compareObjects(key[i], splitKeyStart[i]);
            upperBoundRes[i] = SourceRecordUtils.compareObjects(key[i], splitKeyEnd[i]);
        }
        return Arrays.stream(lowerBoundRes).anyMatch(value -> value >= 0) && Arrays.stream(upperBoundRes).anyMatch(value -> value < 0) && Arrays.stream(upperBoundRes).allMatch(value -> value <= 0);
    }

    private static int compareObjects(Object o1, Object o2) {
        if (o1 instanceof Comparable && o1.getClass().equals(o2.getClass())) {
            return ((Comparable)o1).compareTo(o2);
        }
        if (SourceRecordUtils.isNumericObject(o1) && SourceRecordUtils.isNumericObject(o2)) {
            return SourceRecordUtils.toBigDecimal(o1).compareTo(SourceRecordUtils.toBigDecimal(o2));
        }
        return o1.toString().compareTo(o2.toString());
    }

    private static boolean isNumericObject(Object obj) {
        return obj instanceof Byte || obj instanceof Short || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double || obj instanceof BigInteger || obj instanceof BigDecimal;
    }

    private static BigDecimal toBigDecimal(Object numericObj) {
        return new BigDecimal(numericObj.toString());
    }
}

