/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source;

import com.google.auto.service.AutoService;
import java.time.ZoneId;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.cdc.base.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.cdc.base.config.SourceConfig;
import org.apache.seatunnel.connectors.cdc.base.dialect.DataSourceDialect;
import org.apache.seatunnel.connectors.cdc.base.dialect.JdbcDataSourceDialect;
import org.apache.seatunnel.connectors.cdc.base.option.JdbcSourceOptions;
import org.apache.seatunnel.connectors.cdc.base.source.IncrementalSource;
import org.apache.seatunnel.connectors.cdc.base.source.offset.OffsetFactory;
import org.apache.seatunnel.connectors.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.seatunnel.connectors.cdc.debezium.row.SeaTunnelRowDebeziumDeserializeSchema;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.config.MySqlSourceConfigFactory;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.MySqlDialect;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.offset.BinlogOffsetFactory;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.JdbcCatalogOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.MySqlCatalog;

@AutoService(value={SeaTunnelSource.class})
public class MySqlIncrementalSource<T>
extends IncrementalSource<T, JdbcSourceConfig> {
    public String getPluginName() {
        return "MySQL-CDC";
    }

    @Override
    public SourceConfig.Factory<JdbcSourceConfig> createSourceConfigFactory(ReadonlyConfig config) {
        MySqlSourceConfigFactory configFactory = new MySqlSourceConfigFactory();
        configFactory.serverId((String)config.get(JdbcSourceOptions.SERVER_ID));
        configFactory.fromReadonlyConfig(this.readonlyConfig);
        configFactory.startupOptions(this.startupConfig);
        configFactory.stopOptions(this.stopConfig);
        return configFactory;
    }

    @Override
    public DebeziumDeserializationSchema<T> createDebeziumDeserializationSchema(ReadonlyConfig config) {
        JdbcSourceConfig jdbcSourceConfig = (JdbcSourceConfig)this.configFactory.create(0);
        String baseUrl = (String)config.get(JdbcCatalogOptions.BASE_URL);
        MySqlCatalog mySqlCatalog = new MySqlCatalog("mysql", jdbcSourceConfig.getDatabaseList().get(0), jdbcSourceConfig.getUsername(), jdbcSourceConfig.getPassword(), baseUrl);
        CatalogTable table = mySqlCatalog.getTable(TablePath.of((String)jdbcSourceConfig.getDatabaseList().get(0), (String)((String)config.get(JdbcSourceOptions.TABLE_NAME))));
        SeaTunnelRowType physicalRowType = table.getTableSchema().toPhysicalRowDataType();
        String zoneId = (String)config.get(JdbcSourceOptions.SERVER_TIME_ZONE);
        return SeaTunnelRowDebeziumDeserializeSchema.builder().setPhysicalRowType(physicalRowType).setResultTypeInfo(physicalRowType).setServerTimeZone(ZoneId.of(zoneId)).build();
    }

    @Override
    public DataSourceDialect<JdbcSourceConfig> createDataSourceDialect(ReadonlyConfig config) {
        return new MySqlDialect((MySqlSourceConfigFactory)this.configFactory);
    }

    @Override
    public OffsetFactory createOffsetFactory(ReadonlyConfig config) {
        return new BinlogOffsetFactory((MySqlSourceConfigFactory)this.configFactory, (JdbcDataSourceDialect)this.dataSourceDialect);
    }
}

