/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.reader.fetch.scan;

import io.debezium.DebeziumException;
import io.debezium.connector.mysql.MySqlConnection;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDatabaseSchema;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.AbstractSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.SnapshotResult;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.relational.SnapshotChangeRecordEmitter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.util.Clock;
import io.debezium.util.ColumnUtils;
import io.debezium.util.Strings;
import io.debezium.util.Threads;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.Duration;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.seatunnel.connectors.cdc.base.relational.JdbcSourceEventDispatcher;
import org.apache.seatunnel.connectors.cdc.base.source.split.SnapshotSplit;
import org.apache.seatunnel.connectors.cdc.base.source.split.wartermark.WatermarkKind;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.offset.BinlogOffset;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.reader.fetch.scan.SnapshotSplitChangeEventSourceContext;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.utils.MySqlConnectionUtils;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.utils.MySqlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlSnapshotSplitReadTask
extends AbstractSnapshotChangeEventSource {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlSnapshotSplitReadTask.class);
    private static final Duration LOG_INTERVAL = Duration.ofMillis(10000L);
    private final MySqlConnectorConfig connectorConfig;
    private final MySqlDatabaseSchema databaseSchema;
    private final MySqlConnection jdbcConnection;
    private final JdbcSourceEventDispatcher dispatcher;
    private final Clock clock;
    private final SnapshotSplit snapshotSplit;
    private final MySqlOffsetContext offsetContext;
    private final SnapshotProgressListener snapshotProgressListener;

    public MySqlSnapshotSplitReadTask(MySqlConnectorConfig connectorConfig, MySqlOffsetContext previousOffset, SnapshotProgressListener snapshotProgressListener, MySqlDatabaseSchema databaseSchema, MySqlConnection jdbcConnection, JdbcSourceEventDispatcher dispatcher, SnapshotSplit snapshotSplit) {
        super(connectorConfig, snapshotProgressListener);
        this.offsetContext = previousOffset;
        this.connectorConfig = connectorConfig;
        this.databaseSchema = databaseSchema;
        this.jdbcConnection = jdbcConnection;
        this.dispatcher = dispatcher;
        this.clock = Clock.SYSTEM;
        this.snapshotSplit = snapshotSplit;
        this.snapshotProgressListener = snapshotProgressListener;
    }

    @Override
    public SnapshotResult execute(ChangeEventSource.ChangeEventSourceContext context, OffsetContext previousOffset) throws InterruptedException {
        AbstractSnapshotChangeEventSource.SnapshotContext ctx;
        AbstractSnapshotChangeEventSource.SnapshottingTask snapshottingTask = this.getSnapshottingTask(previousOffset);
        try {
            ctx = this.prepare(context);
        }
        catch (Exception e) {
            LOG.error("Failed to initialize snapshot context.", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            return this.doExecute(context, previousOffset, ctx, snapshottingTask);
        }
        catch (InterruptedException e) {
            LOG.warn("Snapshot was interrupted before completion");
            throw e;
        }
        catch (Exception t) {
            throw new DebeziumException(t);
        }
    }

    protected SnapshotResult doExecute(ChangeEventSource.ChangeEventSourceContext context, OffsetContext previousOffset, AbstractSnapshotChangeEventSource.SnapshotContext snapshotContext, AbstractSnapshotChangeEventSource.SnapshottingTask snapshottingTask) throws Exception {
        RelationalSnapshotChangeEventSource.RelationalSnapshotContext ctx = (RelationalSnapshotChangeEventSource.RelationalSnapshotContext)snapshotContext;
        ctx.offset = this.offsetContext;
        BinlogOffset lowWatermark = MySqlConnectionUtils.currentBinlogOffset(this.jdbcConnection);
        LOG.info("Snapshot step 1 - Determining low watermark {} for split {}", (Object)lowWatermark, (Object)this.snapshotSplit);
        ((SnapshotSplitChangeEventSourceContext)context).setLowWatermark(lowWatermark);
        this.dispatcher.dispatchWatermarkEvent(this.offsetContext.getPartition(), this.snapshotSplit, lowWatermark, WatermarkKind.LOW);
        LOG.info("Snapshot step 2 - Snapshotting data");
        this.createDataEvents(ctx, this.snapshotSplit.getTableId());
        BinlogOffset highWatermark = MySqlConnectionUtils.currentBinlogOffset(this.jdbcConnection);
        LOG.info("Snapshot step 3 - Determining high watermark {} for split {}", (Object)highWatermark, (Object)this.snapshotSplit);
        ((SnapshotSplitChangeEventSourceContext)context).setHighWatermark(highWatermark);
        this.dispatcher.dispatchWatermarkEvent(this.offsetContext.getPartition(), this.snapshotSplit, highWatermark, WatermarkKind.HIGH);
        return SnapshotResult.completed(ctx.offset);
    }

    protected AbstractSnapshotChangeEventSource.SnapshottingTask getSnapshottingTask(OffsetContext previousOffset) {
        return new AbstractSnapshotChangeEventSource.SnapshottingTask(false, true);
    }

    protected AbstractSnapshotChangeEventSource.SnapshotContext prepare(ChangeEventSource.ChangeEventSourceContext changeEventSourceContext) throws Exception {
        return new MySqlSnapshotContext();
    }

    private void createDataEvents(RelationalSnapshotChangeEventSource.RelationalSnapshotContext snapshotContext, TableId tableId) throws Exception {
        EventDispatcher.SnapshotReceiver snapshotReceiver = this.dispatcher.getSnapshotChangeEventReceiver();
        LOG.debug("Snapshotting table {}", (Object)tableId);
        this.createDataEventsForTable(snapshotContext, snapshotReceiver, this.databaseSchema.tableFor(tableId));
        snapshotReceiver.completeSnapshot();
    }

    private void createDataEventsForTable(RelationalSnapshotChangeEventSource.RelationalSnapshotContext snapshotContext, EventDispatcher.SnapshotReceiver snapshotReceiver, Table table) throws InterruptedException {
        long exportStart = this.clock.currentTimeInMillis();
        LOG.info("Exporting data from split '{}' of table {}", (Object)this.snapshotSplit.splitId(), (Object)table.id());
        String selectSql = MySqlUtils.buildSplitScanQuery(this.snapshotSplit.getTableId(), this.snapshotSplit.getSplitKeyType(), this.snapshotSplit.getSplitStart() == null, this.snapshotSplit.getSplitEnd() == null);
        LOG.info("For split '{}' of table {} using select statement: '{}'", new Object[]{this.snapshotSplit.splitId(), table.id(), selectSql});
        try (PreparedStatement selectStatement = MySqlUtils.readTableSplitDataStatement(this.jdbcConnection, selectSql, this.snapshotSplit.getSplitStart() == null, this.snapshotSplit.getSplitEnd() == null, new Object[]{this.snapshotSplit.getSplitStart()}, new Object[]{this.snapshotSplit.getSplitEnd()}, this.snapshotSplit.getSplitKeyType().getTotalFields(), this.connectorConfig.getQueryFetchSize());
             ResultSet rs = selectStatement.executeQuery();){
            ColumnUtils.ColumnArray columnArray = ColumnUtils.toArray(rs, table);
            long rows = 0L;
            Threads.Timer logTimer = this.getTableScanLogTimer();
            while (rs.next()) {
                ++rows;
                Object[] row = new Object[columnArray.getGreatestColumnPosition()];
                for (int i = 0; i < columnArray.getColumns().length; ++i) {
                    row[columnArray.getColumns()[i].position() - 1] = this.readField(rs, i + 1);
                }
                if (logTimer.expired()) {
                    long stop = this.clock.currentTimeInMillis();
                    LOG.info("Exported {} records for split '{}' after {}", new Object[]{rows, this.snapshotSplit.splitId(), Strings.duration(stop - exportStart)});
                    this.snapshotProgressListener.rowsScanned(table.id(), rows);
                    logTimer = this.getTableScanLogTimer();
                }
                this.dispatcher.dispatchSnapshotEvent(table.id(), this.getChangeRecordEmitter(snapshotContext, table.id(), row), snapshotReceiver);
            }
            LOG.info("Finished exporting {} records for split '{}', total duration '{}'", new Object[]{rows, this.snapshotSplit.splitId(), Strings.duration(this.clock.currentTimeInMillis() - exportStart)});
        }
        catch (SQLException e) {
            throw new ConnectException("Snapshotting of table " + table.id() + " failed", e);
        }
    }

    protected ChangeRecordEmitter getChangeRecordEmitter(AbstractSnapshotChangeEventSource.SnapshotContext snapshotContext, TableId tableId, Object[] row) {
        snapshotContext.offset.event(tableId, this.clock.currentTime());
        return new SnapshotChangeRecordEmitter((OffsetContext)snapshotContext.offset, row, this.clock);
    }

    private Threads.Timer getTableScanLogTimer() {
        return Threads.timer(this.clock, LOG_INTERVAL);
    }

    private Object readField(ResultSet rs, int columnIndex) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnType = metaData.getColumnType(columnIndex);
        if (columnType == 92) {
            return rs.getTimestamp(columnIndex);
        }
        return rs.getObject(columnIndex);
    }

    private static class MySqlSnapshotContext
    extends RelationalSnapshotChangeEventSource.RelationalSnapshotContext {
        public MySqlSnapshotContext() throws SQLException {
            super("");
        }
    }
}

