/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog;

import com.mysql.cj.MysqlType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.AbstractJdbcCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;

public class MySqlCatalog
extends AbstractJdbcCatalog {
    private static final Set<String> SYS_DATABASES = new HashSet<String>(4);

    public MySqlCatalog(String catalogName, String defaultDatabase, String username, String pwd, String baseUrl) {
        super(catalogName, defaultDatabase, username, pwd, baseUrl);
    }

    public MySqlCatalog(String catalogName, String username, String pwd, String defaultUrl) {
        super(catalogName, username, pwd, defaultUrl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> listDatabases() throws CatalogException {
        try (Connection conn = DriverManager.getConnection(this.defaultUrl, this.username, this.pwd);){
            PreparedStatement ps = conn.prepareStatement("SHOW DATABASES;");
            ArrayList<String> databases = new ArrayList<String>();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String databaseName = rs.getString(1);
                if (SYS_DATABASES.contains(databaseName)) continue;
                databases.add(rs.getString(1));
            }
            ArrayList<String> arrayList = databases;
            return arrayList;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.catalogName, databaseName);
        }
        try (Connection conn = DriverManager.getConnection(this.baseUrl + databaseName, this.username, this.pwd);){
            PreparedStatement ps = conn.prepareStatement("SHOW TABLES;");
            ResultSet rs = ps.executeQuery();
            ArrayList<String> tables = new ArrayList<String>();
            while (rs.next()) {
                tables.add(rs.getString(1));
            }
            ArrayList<String> arrayList = tables;
            return arrayList;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.catalogName, tablePath);
        }
        String dbUrl = this.baseUrl + tablePath.getDatabaseName();
        try (Connection conn = DriverManager.getConnection(dbUrl, this.username, this.pwd);){
            DatabaseMetaData metaData = conn.getMetaData();
            Optional<TableSchema.PrimaryKey> primaryKey = this.getPrimaryKey(metaData, tablePath.getDatabaseName(), tablePath.getTableName());
            PreparedStatement ps = conn.prepareStatement(String.format("SELECT * FROM %s WHERE 1 = 0;", tablePath.getFullName()));
            ResultSetMetaData tableMetaData = ps.getMetaData();
            TableSchema.Builder builder = TableSchema.builder();
            for (int i = 1; i <= tableMetaData.getColumnCount(); ++i) {
                SeaTunnelDataType<?> type = this.fromJdbcType(tableMetaData, i);
                builder.physicalColumn(tableMetaData.getColumnName(i), type);
            }
            primaryKey.ifPresent(arg_0 -> ((TableSchema.Builder)builder).primaryKey(arg_0));
            TableIdentifier tableIdentifier = TableIdentifier.of((String)this.catalogName, (String)tablePath.getDatabaseName(), (String)tablePath.getTableName());
            CatalogTable catalogTable = CatalogTable.of((TableIdentifier)tableIdentifier, (TableSchema)builder.build(), this.buildConnectorOptions(tablePath), Collections.emptyList(), (String)"");
            return catalogTable;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed getting table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    private SeaTunnelDataType<?> fromJdbcType(ResultSetMetaData metadata, int colIndex) throws SQLException {
        MysqlType mysqlType = MysqlType.getByName(metadata.getColumnTypeName(colIndex));
        switch (mysqlType) {
            case NULL: {
                return BasicType.VOID_TYPE;
            }
            case BOOLEAN: {
                return BasicType.BOOLEAN_TYPE;
            }
            case BIT: 
            case TINYINT: {
                return BasicType.BYTE_TYPE;
            }
            case TINYINT_UNSIGNED: 
            case SMALLINT: {
                return BasicType.SHORT_TYPE;
            }
            case SMALLINT_UNSIGNED: 
            case INT: 
            case MEDIUMINT: 
            case MEDIUMINT_UNSIGNED: {
                return BasicType.INT_TYPE;
            }
            case INT_UNSIGNED: 
            case BIGINT: {
                return BasicType.LONG_TYPE;
            }
            case FLOAT: 
            case FLOAT_UNSIGNED: {
                return BasicType.FLOAT_TYPE;
            }
            case DOUBLE: 
            case DOUBLE_UNSIGNED: {
                return BasicType.DOUBLE_TYPE;
            }
            case TIME: {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case DATE: {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case TIMESTAMP: 
            case DATETIME: {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case CHAR: 
            case VARCHAR: 
            case TINYTEXT: 
            case TEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: 
            case JSON: 
            case ENUM: {
                return BasicType.STRING_TYPE;
            }
            case BINARY: 
            case VARBINARY: 
            case TINYBLOB: 
            case BLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: 
            case GEOMETRY: {
                return PrimitiveByteArrayType.INSTANCE;
            }
            case BIGINT_UNSIGNED: 
            case DECIMAL: 
            case DECIMAL_UNSIGNED: {
                int precision = metadata.getPrecision(colIndex);
                int scale = metadata.getScale(colIndex);
                return new DecimalType(precision, scale);
            }
        }
        throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, String.format("Doesn't support MySQL type '%s' yet", mysqlType.getName()));
    }

    private Map<String, String> buildConnectorOptions(TablePath tablePath) {
        HashMap<String, String> options = new HashMap<String, String>(8);
        options.put("connector", "jdbc");
        options.put("url", this.baseUrl + tablePath.getDatabaseName());
        options.put("table-name", tablePath.getFullName());
        options.put("username", this.username);
        options.put("password", this.pwd);
        return options;
    }

    static {
        SYS_DATABASES.add("information_schema");
        SYS_DATABASES.add("mysql");
        SYS_DATABASES.add("performance_schema");
        SYS_DATABASES.add("sys");
    }
}

