/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.config;

import java.io.Serializable;
import java.util.List;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.options.JdbcConnectionOptions;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class JdbcSinkOptions
implements Serializable {
    private JdbcConnectionOptions jdbcConnectionOptions;
    private boolean isExactlyOnce;
    public String simpleSQL;
    private String table;
    private List<String> primaryKeys;
    private boolean supportUpsertByQueryPrimaryKeyExist;

    public JdbcSinkOptions(Config config) {
        this.jdbcConnectionOptions = JdbcConfig.buildJdbcConnectionOptions(config);
        if (config.hasPath(JdbcConfig.IS_EXACTLY_ONCE.key()) && config.getBoolean(JdbcConfig.IS_EXACTLY_ONCE.key())) {
            this.isExactlyOnce = true;
        }
        if (config.hasPath(JdbcConfig.TABLE.key())) {
            this.table = config.getString(JdbcConfig.TABLE.key());
            if (config.hasPath(JdbcConfig.PRIMARY_KEYS.key())) {
                this.primaryKeys = config.getStringList(JdbcConfig.PRIMARY_KEYS.key());
            }
            this.supportUpsertByQueryPrimaryKeyExist = (Boolean)JdbcConfig.SUPPORT_UPSERT_BY_QUERY_PRIMARY_KEY_EXIST.defaultValue();
            if (config.hasPath(JdbcConfig.SUPPORT_UPSERT_BY_QUERY_PRIMARY_KEY_EXIST.key())) {
                this.supportUpsertByQueryPrimaryKeyExist = config.getBoolean(JdbcConfig.SUPPORT_UPSERT_BY_QUERY_PRIMARY_KEY_EXIST.key());
            }
        } else {
            this.simpleSQL = config.getString(JdbcConfig.QUERY.key());
        }
    }

    public JdbcConnectionOptions getJdbcConnectionOptions() {
        return this.jdbcConnectionOptions;
    }

    public boolean isExactlyOnce() {
        return this.isExactlyOnce;
    }

    public String getSimpleSQL() {
        return this.simpleSQL;
    }

    public String getTable() {
        return this.table;
    }

    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public boolean isSupportUpsertByQueryPrimaryKeyExist() {
        return this.supportUpsertByQueryPrimaryKeyExist;
    }

    public void setJdbcConnectionOptions(JdbcConnectionOptions jdbcConnectionOptions) {
        this.jdbcConnectionOptions = jdbcConnectionOptions;
    }

    public void setExactlyOnce(boolean isExactlyOnce) {
        this.isExactlyOnce = isExactlyOnce;
    }

    public void setSimpleSQL(String simpleSQL) {
        this.simpleSQL = simpleSQL;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setPrimaryKeys(List<String> primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public void setSupportUpsertByQueryPrimaryKeyExist(boolean supportUpsertByQueryPrimaryKeyExist) {
        this.supportUpsertByQueryPrimaryKeyExist = supportUpsertByQueryPrimaryKeyExist;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcSinkOptions)) {
            return false;
        }
        JdbcSinkOptions other = (JdbcSinkOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JdbcConnectionOptions this$jdbcConnectionOptions = this.getJdbcConnectionOptions();
        JdbcConnectionOptions other$jdbcConnectionOptions = other.getJdbcConnectionOptions();
        if (this$jdbcConnectionOptions == null ? other$jdbcConnectionOptions != null : !this$jdbcConnectionOptions.equals(other$jdbcConnectionOptions)) {
            return false;
        }
        if (this.isExactlyOnce() != other.isExactlyOnce()) {
            return false;
        }
        String this$simpleSQL = this.getSimpleSQL();
        String other$simpleSQL = other.getSimpleSQL();
        if (this$simpleSQL == null ? other$simpleSQL != null : !this$simpleSQL.equals(other$simpleSQL)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        List<String> this$primaryKeys = this.getPrimaryKeys();
        List<String> other$primaryKeys = other.getPrimaryKeys();
        if (this$primaryKeys == null ? other$primaryKeys != null : !((Object)this$primaryKeys).equals(other$primaryKeys)) {
            return false;
        }
        return this.isSupportUpsertByQueryPrimaryKeyExist() == other.isSupportUpsertByQueryPrimaryKeyExist();
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcSinkOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JdbcConnectionOptions $jdbcConnectionOptions = this.getJdbcConnectionOptions();
        result = result * 59 + ($jdbcConnectionOptions == null ? 43 : $jdbcConnectionOptions.hashCode());
        result = result * 59 + (this.isExactlyOnce() ? 79 : 97);
        String $simpleSQL = this.getSimpleSQL();
        result = result * 59 + ($simpleSQL == null ? 43 : $simpleSQL.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        List<String> $primaryKeys = this.getPrimaryKeys();
        result = result * 59 + ($primaryKeys == null ? 43 : ((Object)$primaryKeys).hashCode());
        result = result * 59 + (this.isSupportUpsertByQueryPrimaryKeyExist() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "JdbcSinkOptions(jdbcConnectionOptions=" + this.getJdbcConnectionOptions() + ", isExactlyOnce=" + this.isExactlyOnce() + ", simpleSQL=" + this.getSimpleSQL() + ", table=" + this.getTable() + ", primaryKeys=" + this.getPrimaryKeys() + ", supportUpsertByQueryPrimaryKeyExist=" + this.isSupportUpsertByQueryPrimaryKeyExist() + ")";
    }

    public JdbcSinkOptions(JdbcConnectionOptions jdbcConnectionOptions, boolean isExactlyOnce, String simpleSQL, String table, List<String> primaryKeys, boolean supportUpsertByQueryPrimaryKeyExist) {
        this.jdbcConnectionOptions = jdbcConnectionOptions;
        this.isExactlyOnce = isExactlyOnce;
        this.simpleSQL = simpleSQL;
        this.table = table;
        this.primaryKeys = primaryKeys;
        this.supportUpsertByQueryPrimaryKeyExist = supportUpsertByQueryPrimaryKeyExist;
    }
}

