/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.config;

import java.io.Serializable;
import java.util.Optional;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.options.JdbcConnectionOptions;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class JdbcSourceOptions
implements Serializable {
    private JdbcConnectionOptions jdbcConnectionOptions;
    public String query;
    private String partitionColumn;
    private Long partitionUpperBound;
    private Long partitionLowerBound;
    private int fetchSize = (Integer)JdbcConfig.FETCH_SIZE.defaultValue();
    private Integer partitionNumber;

    public JdbcSourceOptions(Config config) {
        this.jdbcConnectionOptions = JdbcConfig.buildJdbcConnectionOptions(config);
        this.query = config.getString(JdbcConfig.QUERY.key());
        if (config.hasPath(JdbcConfig.PARTITION_COLUMN.key())) {
            this.partitionColumn = config.getString(JdbcConfig.PARTITION_COLUMN.key());
        }
        if (config.hasPath(JdbcConfig.PARTITION_UPPER_BOUND.key())) {
            this.partitionUpperBound = config.getLong(JdbcConfig.PARTITION_UPPER_BOUND.key());
        }
        if (config.hasPath(JdbcConfig.PARTITION_LOWER_BOUND.key())) {
            this.partitionLowerBound = config.getLong(JdbcConfig.PARTITION_LOWER_BOUND.key());
        }
        if (config.hasPath(JdbcConfig.PARTITION_NUM.key())) {
            this.partitionNumber = config.getInt(JdbcConfig.PARTITION_NUM.key());
        }
        if (config.hasPath(JdbcConfig.FETCH_SIZE.key())) {
            this.fetchSize = config.getInt(JdbcConfig.FETCH_SIZE.key());
        }
    }

    public JdbcConnectionOptions getJdbcConnectionOptions() {
        return this.jdbcConnectionOptions;
    }

    public Optional<String> getPartitionColumn() {
        return Optional.ofNullable(this.partitionColumn);
    }

    public Optional<Long> getPartitionUpperBound() {
        return Optional.ofNullable(this.partitionUpperBound);
    }

    public Optional<Long> getPartitionLowerBound() {
        return Optional.ofNullable(this.partitionLowerBound);
    }

    public Optional<Integer> getPartitionNumber() {
        return Optional.ofNullable(this.partitionNumber);
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public String getQuery() {
        return this.query;
    }

    public void setJdbcConnectionOptions(JdbcConnectionOptions jdbcConnectionOptions) {
        this.jdbcConnectionOptions = jdbcConnectionOptions;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setPartitionColumn(String partitionColumn) {
        this.partitionColumn = partitionColumn;
    }

    public void setPartitionUpperBound(Long partitionUpperBound) {
        this.partitionUpperBound = partitionUpperBound;
    }

    public void setPartitionLowerBound(Long partitionLowerBound) {
        this.partitionLowerBound = partitionLowerBound;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setPartitionNumber(Integer partitionNumber) {
        this.partitionNumber = partitionNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcSourceOptions)) {
            return false;
        }
        JdbcSourceOptions other = (JdbcSourceOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JdbcConnectionOptions this$jdbcConnectionOptions = this.getJdbcConnectionOptions();
        JdbcConnectionOptions other$jdbcConnectionOptions = other.getJdbcConnectionOptions();
        if (this$jdbcConnectionOptions == null ? other$jdbcConnectionOptions != null : !this$jdbcConnectionOptions.equals(other$jdbcConnectionOptions)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        Optional<String> this$partitionColumn = this.getPartitionColumn();
        Optional<String> other$partitionColumn = other.getPartitionColumn();
        if (this$partitionColumn == null ? other$partitionColumn != null : !((Object)this$partitionColumn).equals(other$partitionColumn)) {
            return false;
        }
        Optional<Long> this$partitionUpperBound = this.getPartitionUpperBound();
        Optional<Long> other$partitionUpperBound = other.getPartitionUpperBound();
        if (this$partitionUpperBound == null ? other$partitionUpperBound != null : !((Object)this$partitionUpperBound).equals(other$partitionUpperBound)) {
            return false;
        }
        Optional<Long> this$partitionLowerBound = this.getPartitionLowerBound();
        Optional<Long> other$partitionLowerBound = other.getPartitionLowerBound();
        if (this$partitionLowerBound == null ? other$partitionLowerBound != null : !((Object)this$partitionLowerBound).equals(other$partitionLowerBound)) {
            return false;
        }
        if (this.getFetchSize() != other.getFetchSize()) {
            return false;
        }
        Optional<Integer> this$partitionNumber = this.getPartitionNumber();
        Optional<Integer> other$partitionNumber = other.getPartitionNumber();
        return !(this$partitionNumber == null ? other$partitionNumber != null : !((Object)this$partitionNumber).equals(other$partitionNumber));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcSourceOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JdbcConnectionOptions $jdbcConnectionOptions = this.getJdbcConnectionOptions();
        result = result * 59 + ($jdbcConnectionOptions == null ? 43 : $jdbcConnectionOptions.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        Optional<String> $partitionColumn = this.getPartitionColumn();
        result = result * 59 + ($partitionColumn == null ? 43 : ((Object)$partitionColumn).hashCode());
        Optional<Long> $partitionUpperBound = this.getPartitionUpperBound();
        result = result * 59 + ($partitionUpperBound == null ? 43 : ((Object)$partitionUpperBound).hashCode());
        Optional<Long> $partitionLowerBound = this.getPartitionLowerBound();
        result = result * 59 + ($partitionLowerBound == null ? 43 : ((Object)$partitionLowerBound).hashCode());
        result = result * 59 + this.getFetchSize();
        Optional<Integer> $partitionNumber = this.getPartitionNumber();
        result = result * 59 + ($partitionNumber == null ? 43 : ((Object)$partitionNumber).hashCode());
        return result;
    }

    public String toString() {
        return "JdbcSourceOptions(jdbcConnectionOptions=" + this.getJdbcConnectionOptions() + ", query=" + this.getQuery() + ", partitionColumn=" + this.getPartitionColumn() + ", partitionUpperBound=" + this.getPartitionUpperBound() + ", partitionLowerBound=" + this.getPartitionLowerBound() + ", fetchSize=" + this.getFetchSize() + ", partitionNumber=" + this.getPartitionNumber() + ")";
    }

    public JdbcSourceOptions(JdbcConnectionOptions jdbcConnectionOptions, String query, String partitionColumn, Long partitionUpperBound, Long partitionLowerBound, int fetchSize, Integer partitionNumber) {
        this.jdbcConnectionOptions = jdbcConnectionOptions;
        this.query = query;
        this.partitionColumn = partitionColumn;
        this.partitionUpperBound = partitionUpperBound;
        this.partitionLowerBound = partitionLowerBound;
        this.fetchSize = fetchSize;
        this.partitionNumber = partitionNumber;
    }
}

