/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.connection;

import com.google.common.base.CaseFormat;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import lombok.NonNull;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.options.JdbcConnectionOptions;

public class DataSourceUtils
implements Serializable {
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";

    public static CommonDataSource buildCommonDataSource(@NonNull JdbcConnectionOptions jdbcConnectionOptions) throws InvocationTargetException, IllegalAccessException {
        if (jdbcConnectionOptions == null) {
            throw new NullPointerException("jdbcConnectionOptions is marked @NonNull but is null");
        }
        CommonDataSource dataSource = (CommonDataSource)DataSourceUtils.loadDataSource(jdbcConnectionOptions.getXaDataSourceClassName());
        DataSourceUtils.setProperties(dataSource, DataSourceUtils.buildDatabaseAccessConfig(jdbcConnectionOptions));
        return dataSource;
    }

    private static Map<String, Object> buildDatabaseAccessConfig(JdbcConnectionOptions jdbcConnectionOptions) {
        HashMap<String, Object> accessConfig = new HashMap<String, Object>();
        accessConfig.put("url", jdbcConnectionOptions.getUrl());
        if (jdbcConnectionOptions.getUsername().isPresent()) {
            accessConfig.put("user", jdbcConnectionOptions.getUsername().get());
        }
        if (jdbcConnectionOptions.getPassword().isPresent()) {
            accessConfig.put("password", jdbcConnectionOptions.getPassword().get());
        }
        return accessConfig;
    }

    private static void setProperties(CommonDataSource commonDataSource, Map<String, Object> databaseAccessConfig) throws InvocationTargetException, IllegalAccessException {
        for (Map.Entry<String, Object> entry : databaseAccessConfig.entrySet()) {
            Optional<Method> method = DataSourceUtils.findSetterMethod(commonDataSource.getClass().getMethods(), entry.getKey());
            if (!method.isPresent()) continue;
            method.get().invoke((Object)commonDataSource, entry.getValue());
        }
    }

    private static Method findGetterMethod(DataSource dataSource, String propertyName) throws NoSuchMethodException {
        String getterMethodName = GETTER_PREFIX + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, propertyName);
        Method result = dataSource.getClass().getMethod(getterMethodName, new Class[0]);
        result.setAccessible(true);
        return result;
    }

    private static Optional<Method> findSetterMethod(Method[] methods, String property) {
        String setterMethodName = SETTER_PREFIX + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, property);
        return Arrays.stream(methods).filter(each -> each.getName().equals(setterMethodName) && 1 == each.getParameterTypes().length).findFirst();
    }

    private static Object loadDataSource(String xaDataSourceClassName) {
        Class<?> xaDataSourceClass;
        try {
            xaDataSourceClass = Thread.currentThread().getContextClassLoader().loadClass(xaDataSourceClassName);
        }
        catch (ClassNotFoundException ignored) {
            try {
                xaDataSourceClass = Class.forName(xaDataSourceClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCode.CLASS_NOT_FOUND, "Failed to load [" + xaDataSourceClassName + "]", ex);
            }
        }
        try {
            return xaDataSourceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCode.REFLECT_CLASS_OPERATION_FAILED, "Failed to instance [" + xaDataSourceClassName + "]", ex);
        }
    }
}

