/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.psql;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresTypeMapper
implements JdbcDialectTypeMapper {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcDialectTypeMapper.class);
    private static final String PG_SMALLSERIAL = "smallserial";
    private static final String PG_SERIAL = "serial";
    private static final String PG_BIGSERIAL = "bigserial";
    private static final String PG_BYTEA = "bytea";
    private static final String PG_BYTEA_ARRAY = "_bytea";
    private static final String PG_SMALLINT = "int2";
    private static final String PG_SMALLINT_ARRAY = "_int2";
    private static final String PG_INTEGER = "int4";
    private static final String PG_INTEGER_ARRAY = "_int4";
    private static final String PG_BIGINT = "int8";
    private static final String PG_BIGINT_ARRAY = "_int8";
    private static final String PG_REAL = "float4";
    private static final String PG_REAL_ARRAY = "_float4";
    private static final String PG_DOUBLE_PRECISION = "float8";
    private static final String PG_DOUBLE_PRECISION_ARRAY = "_float8";
    private static final String PG_NUMERIC = "numeric";
    private static final String PG_NUMERIC_ARRAY = "_numeric";
    private static final String PG_BOOLEAN = "bool";
    private static final String PG_BOOLEAN_ARRAY = "_bool";
    private static final String PG_TIMESTAMP = "timestamp";
    private static final String PG_TIMESTAMP_ARRAY = "_timestamp";
    private static final String PG_TIMESTAMPTZ = "timestamptz";
    private static final String PG_TIMESTAMPTZ_ARRAY = "_timestamptz";
    private static final String PG_DATE = "date";
    private static final String PG_DATE_ARRAY = "_date";
    private static final String PG_TIME = "time";
    private static final String PG_TIME_ARRAY = "_time";
    private static final String PG_TEXT = "text";
    private static final String PG_TEXT_ARRAY = "_text";
    private static final String PG_CHAR = "bpchar";
    private static final String PG_CHAR_ARRAY = "_bpchar";
    private static final String PG_CHARACTER = "character";
    private static final String PG_CHARACTER_ARRAY = "_character";
    private static final String PG_CHARACTER_VARYING = "varchar";
    private static final String PG_CHARACTER_VARYING_ARRAY = "_varchar";

    @Override
    public SeaTunnelDataType<?> mapping(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String pgType = metadata.getColumnTypeName(colIndex);
        int precision = metadata.getPrecision(colIndex);
        int scale = metadata.getScale(colIndex);
        switch (pgType) {
            case "bool": {
                return BasicType.BOOLEAN_TYPE;
            }
            case "_bool": {
                return ArrayType.BOOLEAN_ARRAY_TYPE;
            }
            case "bytea": {
                return PrimitiveByteArrayType.INSTANCE;
            }
            case "_bytea": {
                return ArrayType.BYTE_ARRAY_TYPE;
            }
            case "int2": 
            case "smallserial": 
            case "int4": 
            case "serial": {
                return BasicType.INT_TYPE;
            }
            case "_int2": 
            case "_int4": {
                return ArrayType.INT_ARRAY_TYPE;
            }
            case "int8": 
            case "bigserial": {
                return BasicType.LONG_TYPE;
            }
            case "_int8": {
                return ArrayType.LONG_ARRAY_TYPE;
            }
            case "float4": {
                return BasicType.FLOAT_TYPE;
            }
            case "_float4": {
                return ArrayType.FLOAT_ARRAY_TYPE;
            }
            case "float8": {
                return BasicType.DOUBLE_TYPE;
            }
            case "_float8": {
                return ArrayType.DOUBLE_ARRAY_TYPE;
            }
            case "numeric": {
                if (precision > 0) {
                    return new DecimalType(precision, metadata.getScale(colIndex));
                }
                return new DecimalType(38, 18);
            }
            case "bpchar": 
            case "character": 
            case "varchar": 
            case "text": {
                return BasicType.STRING_TYPE;
            }
            case "_bpchar": 
            case "_character": 
            case "_varchar": 
            case "_text": {
                return ArrayType.STRING_ARRAY_TYPE;
            }
            case "timestamp": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "time": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "date": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
        }
        throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, String.format("Doesn't support Postgres type '%s' yet", pgType));
    }
}

