/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.executor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import lombok.NonNull;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.executor.StatementFactory;

public class SimpleBatchStatementExecutor
implements JdbcBatchStatementExecutor<SeaTunnelRow> {
    @NonNull
    private final StatementFactory statementFactory;
    @NonNull
    private final SeaTunnelRowType rowType;
    @NonNull
    private final JdbcRowConverter converter;
    private transient PreparedStatement statement;

    @Override
    public void prepareStatements(Connection connection) throws SQLException {
        this.statement = this.statementFactory.createStatement(connection);
    }

    @Override
    public void addToBatch(SeaTunnelRow record) throws SQLException {
        this.converter.toExternal(this.rowType, record, this.statement);
        this.statement.addBatch();
    }

    @Override
    public void executeBatch() throws SQLException {
        this.statement.executeBatch();
        this.statement.clearBatch();
    }

    @Override
    public void closeStatements() throws SQLException {
        if (this.statement != null) {
            this.statement.close();
        }
    }

    public SimpleBatchStatementExecutor(@NonNull StatementFactory statementFactory, @NonNull SeaTunnelRowType rowType, @NonNull JdbcRowConverter converter) {
        if (statementFactory == null) {
            throw new NullPointerException("statementFactory is marked @NonNull but is null");
        }
        if (rowType == null) {
            throw new NullPointerException("rowType is marked @NonNull but is null");
        }
        if (converter == null) {
            throw new NullPointerException("converter is marked @NonNull but is null");
        }
        this.statementFactory = statementFactory;
        this.rowType = rowType;
        this.converter = converter;
    }
}

