/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.source;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.split.JdbcNumericBetweenParametersProvider;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.PartitionParameter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.state.JdbcSourceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSourceSplitEnumerator
implements SourceSplitEnumerator<JdbcSourceSplit, JdbcSourceState> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcSourceSplitEnumerator.class);
    private final SourceSplitEnumerator.Context<JdbcSourceSplit> enumeratorContext;
    private final Map<Integer, Set<JdbcSourceSplit>> pendingSplits;
    private JdbcSourceOptions jdbcSourceOptions;
    private final PartitionParameter partitionParameter;

    public JdbcSourceSplitEnumerator(SourceSplitEnumerator.Context<JdbcSourceSplit> enumeratorContext, JdbcSourceOptions jdbcSourceOptions, PartitionParameter partitionParameter) {
        this.enumeratorContext = enumeratorContext;
        this.jdbcSourceOptions = jdbcSourceOptions;
        this.partitionParameter = partitionParameter;
        this.pendingSplits = new HashMap<Integer, Set<JdbcSourceSplit>>();
    }

    public void open() {
    }

    public void run() throws Exception {
        this.discoverySplits();
        this.assignPendingSplits();
    }

    private void discoverySplits() {
        ArrayList<JdbcSourceSplit> allSplit = new ArrayList<JdbcSourceSplit>();
        LOG.info("Starting to calculate splits.");
        if (null != this.partitionParameter) {
            int partitionNumber = this.partitionParameter.getPartitionNumber() != null ? this.partitionParameter.getPartitionNumber().intValue() : this.enumeratorContext.currentParallelism();
            JdbcNumericBetweenParametersProvider jdbcNumericBetweenParametersProvider = new JdbcNumericBetweenParametersProvider(this.partitionParameter.minValue, this.partitionParameter.maxValue).ofBatchNum(partitionNumber);
            Serializable[][] parameterValues = jdbcNumericBetweenParametersProvider.getParameterValues();
            for (int i = 0; i < parameterValues.length; ++i) {
                allSplit.add(new JdbcSourceSplit(parameterValues[i], i));
            }
        } else {
            allSplit.add(new JdbcSourceSplit(null, 0));
        }
        int numReaders = this.enumeratorContext.currentParallelism();
        for (JdbcSourceSplit split : allSplit) {
            int ownerReader = split.splitId % numReaders;
            this.pendingSplits.computeIfAbsent(ownerReader, r -> new HashSet()).add(split);
        }
        LOG.debug("Assigned {} to {} readers.", allSplit, (Object)numReaders);
        LOG.info("Calculated splits successfully, the size of splits is {}.", (Object)allSplit.size());
    }

    private void assignPendingSplits() {
        Iterator iterator = this.enumeratorContext.registeredReaders().iterator();
        while (iterator.hasNext()) {
            int pendingReader = (Integer)iterator.next();
            Set<JdbcSourceSplit> pendingAssignmentForReader = this.pendingSplits.remove(pendingReader);
            if (pendingAssignmentForReader != null && !pendingAssignmentForReader.isEmpty()) {
                LOG.info("Assigning splits to readers {}", pendingAssignmentForReader);
                this.enumeratorContext.assignSplit(pendingReader, new ArrayList<JdbcSourceSplit>(pendingAssignmentForReader));
            }
            this.enumeratorContext.signalNoMoreSplits(pendingReader);
        }
    }

    public void close() throws IOException {
    }

    public void addSplitsBack(List<JdbcSourceSplit> splits, int subtaskId) {
    }

    public int currentUnassignedSplitSize() {
        return 0;
    }

    public void handleSplitRequest(int subtaskId) {
    }

    public void registerReader(int subtaskId) {
    }

    public JdbcSourceState snapshotState(long checkpointId) throws Exception {
        return null;
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
    }
}

