/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.debezium;

import io.debezium.config.Configuration;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.relational.history.DatabaseHistoryException;
import io.debezium.relational.history.DatabaseHistoryListener;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.TableChanges;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class EmbeddedDatabaseHistory
implements DatabaseHistory {
    public static final String DATABASE_HISTORY_INSTANCE_NAME = "database.history.instance.name";
    public static final ConcurrentMap<String, Collection<TableChanges.TableChange>> TABLE_SCHEMAS = new ConcurrentHashMap<String, Collection<TableChanges.TableChange>>();
    private Map<TableId, TableChanges.TableChange> tableSchemas;
    private DatabaseHistoryListener listener;
    private boolean storeOnlyMonitoredTablesDdl;
    private boolean skipUnparseableDDL;

    @Override
    public void configure(Configuration config, HistoryRecordComparator comparator, DatabaseHistoryListener listener, boolean useCatalogBeforeSchema) {
        this.listener = listener;
        this.storeOnlyMonitoredTablesDdl = config.getBoolean(STORE_ONLY_MONITORED_TABLES_DDL);
        this.skipUnparseableDDL = config.getBoolean(SKIP_UNPARSEABLE_DDL_STATEMENTS);
        String instanceName = config.getString(DATABASE_HISTORY_INSTANCE_NAME);
        this.tableSchemas = new HashMap<TableId, TableChanges.TableChange>();
        for (TableChanges.TableChange tableChange : EmbeddedDatabaseHistory.removeHistory(instanceName)) {
            this.tableSchemas.put(tableChange.getId(), tableChange);
        }
    }

    @Override
    public void start() {
        this.listener.started();
    }

    @Override
    public void record(Map<String, ?> source, Map<String, ?> position, String databaseName, String ddl) throws DatabaseHistoryException {
        throw new UnsupportedOperationException("should not call here, error");
    }

    @Override
    public void record(Map<String, ?> source, Map<String, ?> position, String databaseName, String schemaName, String ddl, TableChanges changes) throws DatabaseHistoryException {
        HistoryRecord record = new HistoryRecord(source, position, databaseName, schemaName, ddl, changes);
        this.listener.onChangeApplied(record);
    }

    @Override
    public void recover(Map<String, ?> source, Map<String, ?> position, Tables schema, DdlParser ddlParser) {
        this.listener.recoveryStarted();
        for (TableChanges.TableChange tableChange : this.tableSchemas.values()) {
            schema.overwriteTable(tableChange.getTable());
        }
        this.listener.recoveryStopped();
    }

    @Override
    public void recover(Map<Map<String, ?>, Map<String, ?>> offsets, Tables schema, DdlParser ddlParser) {
        offsets.forEach((source, position) -> this.recover((Map<String, ?>)source, (Map<String, ?>)position, schema, ddlParser));
    }

    @Override
    public void stop() {
        this.listener.stopped();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean storageExists() {
        return true;
    }

    @Override
    public void initializeStorage() {
    }

    @Override
    public boolean storeOnlyCapturedTables() {
        return this.storeOnlyMonitoredTablesDdl;
    }

    @Override
    public boolean skipUnparseableDdlStatements() {
        return this.skipUnparseableDDL;
    }

    public static void registerHistory(String engineName, Collection<TableChanges.TableChange> engineHistory) {
        TABLE_SCHEMAS.put(engineName, engineHistory);
    }

    public static Collection<TableChanges.TableChange> removeHistory(String engineName) {
        if (engineName == null) {
            return Collections.emptyList();
        }
        List<TableChanges.TableChange> tableChanges = (List<TableChanges.TableChange>)TABLE_SCHEMAS.remove(engineName);
        return tableChanges != null ? tableChanges : Collections.emptyList();
    }
}

