/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mysql.utils;

import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDefaultValueConverter;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import java.util.Optional;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.connectors.seatunnel.common.source.TypeDefineUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.mysql.MySqlTypeConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.utils.DefaultValueUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlTypeUtils {
    private static final Logger log = LoggerFactory.getLogger(MySqlTypeUtils.class);

    public static SeaTunnelDataType<?> convertFromColumn(io.debezium.relational.Column column, RelationalDatabaseConnectorConfig dbzConnectorConfig) {
        return MySqlTypeUtils.convertToSeaTunnelColumn(column, dbzConnectorConfig).getDataType();
    }

    public static Column convertToSeaTunnelColumn(io.debezium.relational.Column column, RelationalDatabaseConnectorConfig dbzConnectorConfig) {
        String bigIntUnsignedHandlingModeStr = dbzConnectorConfig.getConfig().getString(MySqlConnectorConfig.BIGINT_UNSIGNED_HANDLING_MODE);
        boolean timeAdjusterEnabled = dbzConnectorConfig.getConfig().getBoolean(MySqlConnectorConfig.ENABLE_TIME_ADJUSTER);
        MySqlConnectorConfig.BigIntUnsignedHandlingMode bigIntUnsignedHandlingMode = MySqlConnectorConfig.BigIntUnsignedHandlingMode.parse(bigIntUnsignedHandlingModeStr);
        MySqlValueConverters mySqlValueConverters = new MySqlValueConverters(dbzConnectorConfig.getDecimalMode(), dbzConnectorConfig.getTemporalPrecisionMode(), bigIntUnsignedHandlingMode.asBigIntUnsignedMode(), dbzConnectorConfig.binaryHandlingMode(), timeAdjusterEnabled ? MySqlValueConverters::adjustTemporal : x -> x, MySqlValueConverters::defaultParsingErrorHandler);
        MySqlDefaultValueConverter mySqlDefaultValueConverter = new MySqlDefaultValueConverter(mySqlValueConverters);
        Optional<String> defaultValueExpression = column.defaultValueExpression();
        Object defaultValue = defaultValueExpression.orElse(null);
        if (defaultValueExpression.isPresent() && !DefaultValueUtils.isMysqlSpecialDefaultValue(defaultValue)) {
            defaultValue = mySqlDefaultValueConverter.parseDefaultValue(column, defaultValueExpression.get()).orElse(null);
        }
        BasicTypeDefine.BasicTypeDefineBuilder builder = BasicTypeDefine.builder().name(column.name()).columnType(column.typeName()).dataType(column.typeName()).scale(column.scale().orElse(0)).nullable(column.isOptional()).defaultValue(defaultValue);
        if (column.length() >= 0) {
            builder.length(Long.valueOf(column.length())).precision(Long.valueOf(column.length()));
        }
        switch (column.typeName().toUpperCase()) {
            case "CHAR": 
            case "VARCHAR": {
                if (column.length() <= 0) {
                    builder.columnType("VARCHAR");
                    builder.length(TypeDefineUtils.charTo4ByteLength(1L));
                    break;
                }
                builder.columnType(String.format("%s(%s)", "VARCHAR", column.length()));
                builder.length(TypeDefineUtils.charTo4ByteLength(Long.valueOf(column.length())));
                break;
            }
            case "TIME": {
                if (column.length() <= 0) {
                    builder.columnType("TIME");
                    break;
                }
                builder.columnType(String.format("%s(%s)", "TIME", column.length()));
                builder.scale(Integer.valueOf(column.length()));
                break;
            }
            case "TIMESTAMP": {
                if (column.length() <= 0) {
                    builder.columnType("TIMESTAMP");
                    break;
                }
                builder.columnType(String.format("%s(%s)", "TIMESTAMP", column.length()));
                builder.scale(Integer.valueOf(column.length()));
                break;
            }
            case "DATETIME": {
                if (column.length() <= 0) {
                    builder.columnType("DATETIME");
                    break;
                }
                builder.columnType(String.format("%s(%s)", "DATETIME", column.length()));
                builder.scale(Integer.valueOf(column.length()));
                break;
            }
        }
        return MySqlTypeConverter.DEFAULT_INSTANCE.convert(builder.build());
    }
}

